/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.init.BiomeKeys;
import twilightforest.world.components.BiomeGrassColors;

public final class FoliageColorHandler {
    private static final Map<Biome, Handler> HANDLES = new WeakHashMap<Biome, Handler>();

    public static int get(int o, Biome biome, double x, double z) {
        Handler handler = HANDLES.get(biome);
        if (handler == null) {
            handler = Handler.REGISTRY.getOrDefault(ForgeRegistries.BIOMES.getKey((Object)biome), Handler.DEFAULT);
            HANDLES.put(biome, handler);
        }
        return handler.apply(o, x, z);
    }

    @FunctionalInterface
    private static interface Handler {
        public static final Map<ResourceLocation, Handler> REGISTRY = new HashMap<ResourceLocation, Handler>(){
            {
                this.put(BiomeKeys.SPOOKY_FOREST.m_135782_(), (o, x, z) -> {
                    double noise = (Biome.f_47435_.m_75449_(x * 0.0225, z * 0.0225, false) + 1.0) / 2.0;
                    return BiomeGrassColors.blendColors(16745729, 16252673, noise > 0.6 ? noise * 0.2 : noise);
                });
                this.put(BiomeKeys.ENCHANTED_FOREST.m_135782_(), (o, x, z) -> (o & 0xFFFF00) + BiomeGrassColors.getEnchantedColor((int)x, (int)z));
                this.put(BiomeKeys.DARK_FOREST_CENTER.m_135782_(), (o, x, z) -> {
                    double noise = (Biome.f_47435_.m_75449_(x * 0.0225, z * 0.0225, false) + 1.0) / 2.0;
                    return noise < -0.1 ? 16351774 : 15289876;
                });
                this.put(BiomeKeys.DARK_FOREST.m_135782_(), (o, x, z) -> ((FoliageColor.m_46107_((double)0.7f, (double)0.8f) & 0xFEFEFE) + 1969742) / 2);
                this.put(BiomeKeys.SWAMP.m_135782_(), (o, x, z) -> ((FoliageColor.m_46107_((double)0.8f, (double)0.9f) & 0xFEFEFE) + 0x4E0E4E) / 2);
            }
        };
        public static final Handler DEFAULT = (o, x, z) -> o;

        public int apply(int var1, double var2, double var4);
    }
}

