/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFLandmark;
import twilightforest.network.MagicMapPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.LegacyLandmarkPlacements;

public class TFMagicMapData
extends MapItemSavedData {
    private static final Map<String, TFMagicMapData> CLIENT_DATA = new HashMap<String, TFMagicMapData>();
    public final Set<TFMapDecoration> tfDecorations = new HashSet<TFMapDecoration>();

    public TFMagicMapData(int x, int z, byte scale, boolean trackpos, boolean unlimited, boolean locked, ResourceKey<Level> dim) {
        super(x, z, scale, trackpos, unlimited, locked, dim);
    }

    public static TFMagicMapData load(CompoundTag nbt) {
        MapItemSavedData data = MapItemSavedData.m_164807_((CompoundTag)nbt);
        boolean trackingPosition = !nbt.m_128425_("trackingPosition", 1) || nbt.m_128471_("trackingPosition");
        boolean unlimitedTracking = nbt.m_128471_("unlimitedTracking");
        boolean locked = nbt.m_128471_("locked");
        TFMagicMapData tfdata = new TFMagicMapData(data.f_77885_, data.f_77886_, data.f_77890_, trackingPosition, unlimitedTracking, locked, (ResourceKey<Level>)data.f_77887_);
        tfdata.f_77891_ = data.f_77891_;
        tfdata.f_77897_.putAll(data.f_77897_);
        tfdata.f_77894_.putAll(data.f_77894_);
        tfdata.f_77898_.putAll(data.f_77898_);
        tfdata.f_181308_ = data.f_181308_;
        byte[] featureStorage = nbt.m_128463_("features");
        if (featureStorage.length > 0) {
            tfdata.deserializeFeatures(featureStorage);
        }
        return tfdata;
    }

    public CompoundTag m_7176_(CompoundTag cmp) {
        cmp = super.m_7176_(cmp);
        if (this.tfDecorations.size() > 0) {
            cmp.m_128382_("features", this.serializeFeatures());
        }
        return cmp;
    }

    public void checkExistingFeatures(Level world) {
        ArrayList<TFMapDecoration> toRemove = new ArrayList<TFMapDecoration>();
        ArrayList<TFMapDecoration> toAdd = new ArrayList<TFMapDecoration>();
        for (TFMapDecoration coord : this.tfDecorations) {
            int worldZ;
            int worldX = (coord.m_77804_() << this.f_77890_ - 1) + this.f_77885_;
            int trueId = TFMapDecoration.ICONS_FLIPPED.getInt((Object)LegacyLandmarkPlacements.pickLandmarkAtBlock(worldX, worldZ = (coord.m_77805_() << this.f_77890_ - 1) + this.f_77886_, (WorldGenLevel)((ServerLevel)world)));
            if (coord.featureId == trueId) continue;
            toRemove.add(coord);
            toAdd.add(new TFMapDecoration(trueId, coord.m_77804_(), coord.m_77805_(), coord.m_77806_()));
        }
        toRemove.forEach(this.tfDecorations::remove);
        this.tfDecorations.addAll(toAdd);
    }

    public void deserializeFeatures(byte[] arr) {
        this.tfDecorations.clear();
        for (int i = 0; i < arr.length / 3; ++i) {
            byte featureId = arr[i * 3];
            byte mapX = arr[i * 3 + 1];
            byte mapZ = arr[i * 3 + 2];
            byte mapRotation = 8;
            this.tfDecorations.add(new TFMapDecoration(featureId, mapX, mapZ, mapRotation));
        }
    }

    public byte[] serializeFeatures() {
        byte[] storage = new byte[this.tfDecorations.size() * 3];
        int i = 0;
        for (TFMapDecoration featureCoord : this.tfDecorations) {
            storage[i * 3] = (byte)featureCoord.featureId;
            storage[i * 3 + 1] = featureCoord.m_77804_();
            storage[i * 3 + 2] = featureCoord.m_77805_();
            ++i;
        }
        return storage;
    }

    @Nullable
    public static TFMagicMapData getMagicMapData(Level world, String name) {
        if (world.f_46443_) {
            return CLIENT_DATA.get(name);
        }
        return (TFMagicMapData)((ServerLevel)world).m_7654_().m_129783_().m_8895_().m_164858_(TFMagicMapData::load, name);
    }

    public static void registerMagicMapData(Level world, TFMagicMapData data, String id) {
        if (world.f_46443_) {
            CLIENT_DATA.put(id, data);
        } else {
            ((ServerLevel)world).m_7654_().m_129783_().m_8895_().m_164855_(id, (SavedData)data);
        }
    }

    @Nullable
    public Packet<?> m_164796_(int mapId, Player player) {
        Packet packet;
        Packet packet2 = super.m_164796_(mapId, player);
        if (packet2 instanceof ClientboundMapItemDataPacket) {
            ClientboundMapItemDataPacket mapItemDataPacket = (ClientboundMapItemDataPacket)packet2;
            packet = TFPacketHandler.CHANNEL.toVanillaPacket((Object)new MagicMapPacket(this, mapItemDataPacket), NetworkDirection.PLAY_TO_CLIENT);
        } else {
            packet = packet2;
        }
        return packet;
    }

    public static class TFMapDecoration
    extends MapDecoration {
        private static final Int2ObjectArrayMap<TFLandmark> ICONS = new Int2ObjectArrayMap<TFLandmark>(){
            {
                this.defaultReturnValue(TFLandmark.NOTHING);
                this.put(0, TFLandmark.NOTHING);
                this.put(1, TFLandmark.SMALL_HILL);
                this.put(2, TFLandmark.MEDIUM_HILL);
                this.put(3, TFLandmark.LARGE_HILL);
                this.put(4, TFLandmark.HEDGE_MAZE);
                this.put(5, TFLandmark.NAGA_COURTYARD);
                this.put(6, TFLandmark.LICH_TOWER);
                this.put(7, TFLandmark.ICE_TOWER);
                this.put(9, TFLandmark.QUEST_GROVE);
                this.put(12, TFLandmark.HYDRA_LAIR);
                this.put(13, TFLandmark.LABYRINTH);
                this.put(14, TFLandmark.DARK_TOWER);
                this.put(15, TFLandmark.KNIGHT_STRONGHOLD);
                this.put(17, TFLandmark.YETI_CAVE);
                this.put(18, TFLandmark.TROLL_CAVE);
                this.put(19, TFLandmark.FINAL_CASTLE);
            }
        };
        private static final Object2IntArrayMap<TFLandmark> ICONS_FLIPPED = new Object2IntArrayMap<TFLandmark>(){
            {
                ICONS.forEach((k, v) -> this.put(v, (int)k));
            }
        };
        final int featureId;

        public TFMapDecoration(TFLandmark featureId, byte xIn, byte yIn, byte rotationIn) {
            this(ICONS_FLIPPED.getInt((Object)featureId), xIn, yIn, rotationIn);
        }

        public TFMapDecoration(int featureId, byte xIn, byte yIn, byte rotationIn) {
            super(MapDecoration.Type.TARGET_X, xIn, yIn, rotationIn, (Component)Component.m_237115_((String)"map.magic.text"));
            this.featureId = featureId;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean render(int idx) {
            if (((TFLandmark)TFMapDecoration.ICONS.get((int)this.featureId)).isStructureEnabled) {
                RenderContext.stack.m_85836_();
                RenderContext.stack.m_85837_((double)(0.0f + (float)this.m_77804_() / 2.0f + 64.0f), (double)(0.0f + (float)this.m_77805_() / 2.0f + 64.0f), (double)-0.02f);
                RenderContext.stack.m_85845_(Vector3f.f_122227_.m_122240_((float)(this.m_77806_() * 360) / 16.0f));
                RenderContext.stack.m_85841_(4.0f, 4.0f, 3.0f);
                RenderContext.stack.m_85837_(-0.125, 0.125, 0.0);
                float f1 = (float)(this.featureId % 8) / 8.0f;
                float f2 = (float)(this.featureId / 8) / 8.0f;
                float f3 = (float)(this.featureId % 8 + 1) / 8.0f;
                float f4 = (float)(this.featureId / 8 + 1) / 8.0f;
                Matrix4f matrix4f1 = RenderContext.stack.m_85850_().m_85861_();
                VertexConsumer ivertexbuilder1 = RenderContext.buffer.m_6299_(RenderContext.MAP_ICONS);
                ivertexbuilder1.m_85982_(matrix4f1, -1.0f, 1.0f, (float)idx * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f1, f2).m_85969_(RenderContext.light).m_5752_();
                ivertexbuilder1.m_85982_(matrix4f1, 1.0f, 1.0f, (float)idx * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f3, f2).m_85969_(RenderContext.light).m_5752_();
                ivertexbuilder1.m_85982_(matrix4f1, 1.0f, -1.0f, (float)idx * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f3, f4).m_85969_(RenderContext.light).m_5752_();
                ivertexbuilder1.m_85982_(matrix4f1, -1.0f, -1.0f, (float)idx * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(f1, f4).m_85969_(RenderContext.light).m_5752_();
                RenderContext.stack.m_85849_();
            }
            return true;
        }

        public boolean equals(Object o) {
            if (super.equals(o) && o instanceof TFMapDecoration) {
                TFMapDecoration tfMapDecoration = (TFMapDecoration)((Object)o);
                return this.featureId == tfMapDecoration.featureId;
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() * 31 + this.featureId;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class RenderContext {
            private static final RenderType MAP_ICONS = RenderType.m_110497_((ResourceLocation)TwilightForestMod.prefix("textures/gui/mapicons.png"));
            public static PoseStack stack;
            public static MultiBufferSource buffer;
            public static int light;
        }
    }
}

