/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrollsteinnBlock
extends Block {
    private static final BooleanProperty DOWN_LIT = BooleanProperty.m_61465_((String)"down");
    private static final BooleanProperty UP_LIT = BooleanProperty.m_61465_((String)"up");
    private static final BooleanProperty NORTH_LIT = BooleanProperty.m_61465_((String)"north");
    private static final BooleanProperty SOUTH_LIT = BooleanProperty.m_61465_((String)"south");
    private static final BooleanProperty WEST_LIT = BooleanProperty.m_61465_((String)"west");
    private static final BooleanProperty EAST_LIT = BooleanProperty.m_61465_((String)"east");
    private static final Map<Direction, BooleanProperty> PROPERTY_MAP = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)DOWN_LIT).put((Object)Direction.UP, (Object)UP_LIT).put((Object)Direction.NORTH, (Object)NORTH_LIT).put((Object)Direction.SOUTH, (Object)SOUTH_LIT).put((Object)Direction.WEST, (Object)WEST_LIT).put((Object)Direction.EAST, (Object)EAST_LIT).build();
    private static final int LIGHT_THRESHOLD = 7;

    public TrollsteinnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DOWN_LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP_LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH_LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH_LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST_LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST_LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DOWN_LIT, UP_LIT, NORTH_LIT, SOUTH_LIT, WEST_LIT, EAST_LIT});
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState newState = state;
        for (Direction direction : Direction.values()) {
            newState = (BlockState)newState.m_61124_((Property)PROPERTY_MAP.get(direction), (Comparable)Boolean.valueOf(level.m_46803_(pos.m_121945_(direction)) > 7));
        }
        if (!newState.equals(state)) {
            level.m_46597_(pos, newState);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        int peak = 0;
        for (Direction direction : Direction.values()) {
            peak = Math.max(level.m_46803_(pos.m_121945_(direction)), peak);
        }
        return peak;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState ret = this.m_49966_();
        for (Map.Entry<Direction, BooleanProperty> e : PROPERTY_MAP.entrySet()) {
            int light = ctx.m_43725_().m_46803_(ctx.m_8083_().m_121945_(e.getKey()));
            ret = (BlockState)ret.m_61124_((Property)e.getValue(), (Comparable)Boolean.valueOf(light > 7));
        }
        return ret;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(2) == 0) {
            this.sparkle(level, pos);
        }
    }

    private void sparkle(Level level, BlockPos pos) {
        RandomSource random = level.m_213780_();
        int threshold = 7;
        for (Direction side : Direction.values()) {
            double rx = (float)pos.m_123341_() + random.m_188501_();
            double ry = (float)pos.m_123342_() + random.m_188501_();
            double rz = (float)pos.m_123343_() + random.m_188501_();
            if (side == Direction.DOWN && !level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos) && level.m_46803_(pos.m_7495_()) <= threshold) {
                ry = (double)pos.m_123342_() - 0.0625;
            }
            if (side == Direction.UP && !level.m_8055_(pos.m_7494_()).m_60804_((BlockGetter)level, pos) && level.m_46803_(pos.m_7494_()) <= threshold) {
                ry = (double)pos.m_123342_() + 0.0625 + 1.0;
            }
            if (side == Direction.NORTH && !level.m_8055_(pos.m_122012_()).m_60804_((BlockGetter)level, pos) && level.m_46803_(pos.m_122012_()) <= threshold) {
                rz = (double)pos.m_123343_() - 0.0625;
            }
            if (side == Direction.SOUTH && !level.m_8055_(pos.m_122019_()).m_60804_((BlockGetter)level, pos) && level.m_46803_(pos.m_122019_()) <= threshold) {
                rz = (double)pos.m_123343_() + 0.0625 + 1.0;
            }
            if (side == Direction.WEST && !level.m_8055_(pos.m_122024_()).m_60804_((BlockGetter)level, pos) && level.m_46803_(pos.m_122024_()) <= threshold) {
                rx = (double)pos.m_123341_() - 0.0625;
            }
            if (side == Direction.EAST && !level.m_8055_(pos.m_122029_()).m_60804_((BlockGetter)level, pos) && level.m_46803_(pos.m_122029_()) <= threshold) {
                rx = (double)pos.m_123341_() + 0.0625 + 1.0;
            }
            if (!(rx < (double)pos.m_123341_() || rx > (double)(pos.m_123341_() + 1) || ry < 0.0 || ry > (double)(pos.m_123342_() + 1) || rz < (double)pos.m_123343_()) && !(rz > (double)(pos.m_123343_() + 1))) continue;
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.0f, 0.5f), 1.0f), rx, ry, rz, 0.25, -1.0, 0.5);
        }
    }
}

