/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity.spawner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BossSpawnerBlockEntity<T extends Mob>
extends BlockEntity {
    protected static final int SHORT_RANGE = 9;
    protected static final int LONG_RANGE = 50;
    protected final EntityType<T> entityType;
    protected boolean spawnedBoss = false;

    protected BossSpawnerBlockEntity(BlockEntityType<?> type, EntityType<T> entityType, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.entityType = entityType;
    }

    public boolean anyPlayerInRange() {
        return this.m_58904_().m_45914_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, (double)this.getRange());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BossSpawnerBlockEntity<?> te) {
        if (te.spawnedBoss || !te.anyPlayerInRange()) {
            return;
        }
        if (level.m_5776_()) {
            double rx = (float)pos.m_123341_() - 0.2f + level.m_213780_().m_188501_() * 1.25f;
            double ry = (float)pos.m_123342_() - 0.2f + level.m_213780_().m_188501_() * 1.25f;
            double rz = (float)pos.m_123343_() - 0.2f + level.m_213780_().m_188501_() * 1.25f;
            level.m_7106_(te.getSpawnerParticle(), rx, ry, rz, 0.0, 0.0, 0.0);
        } else if (level.m_46791_() != Difficulty.PEACEFUL && te.spawnMyBoss((ServerLevelAccessor)((ServerLevel)level))) {
            level.m_46961_(pos, false);
            te.spawnedBoss = true;
        }
    }

    protected boolean spawnMyBoss(ServerLevelAccessor accessor) {
        T myCreature = this.makeMyCreature();
        myCreature.m_20035_(this.m_58899_().m_7495_(), accessor.m_6018_().m_213780_().m_188501_() * 360.0f, 0.0f);
        myCreature.m_6518_(accessor, accessor.m_6436_(this.m_58899_()), MobSpawnType.SPAWNER, null, null);
        this.initializeCreature(myCreature);
        return accessor.m_7967_(myCreature);
    }

    public abstract ParticleOptions getSpawnerParticle();

    protected void initializeCreature(T myCreature) {
        myCreature.m_21446_(this.m_58899_(), 46);
    }

    protected int getRange() {
        return 9;
    }

    protected T makeMyCreature() {
        return (T)((Mob)this.entityType.m_20615_(this.m_58904_()));
    }
}

