/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import java.util.Random;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.entity.monster.CarminiteGhastguard;

@OnlyIn(value=Dist.CLIENT)
public class TFGhastModel<T extends CarminiteGhastguard>
extends HierarchicalModel<T> {
    protected static final int tentacleCount = 9;
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart[] tentacles = new ModelPart[9];

    public TFGhastModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i] = this.body.m_171324_("tentacle_" + i);
        }
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partRoot = mesh.m_171576_();
        PartDefinition body = partRoot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        Random rand = new Random(1660L);
        for (int i = 0; i < 9; ++i) {
            TFGhastModel.makeTentacle(body, "tentacle_" + i, rand, i);
        }
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    private static PartDefinition makeTentacle(PartDefinition parent, String name, Random random, int i) {
        int length = random.nextInt(7) + 8;
        float xPoint = (((float)(i % 3) - (float)(i / 3 % 2) * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
        float zPoint = ((float)(i / 3) / 2.0f * 2.0f - 1.0f) * 5.0f;
        return parent.m_171599_(name, CubeListBuilder.m_171558_().m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, (float)length, 2.0f), PartPose.m_171419_((float)xPoint, (float)7.0f, (float)zPoint));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].f_104203_ = 0.2f * Mth.m_14031_((float)(ageInTicks * 0.3f + (float)i)) + 0.4f;
        }
        this.body.f_104203_ = headPitch / 57.295776f;
        this.body.f_104204_ = netHeadYaw / 57.295776f;
    }
}

