/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import twilightforest.TwilightForestMod;
import twilightforest.block.entity.RedThreadBlockEntity;
import twilightforest.client.TFShaders;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.RedThreadModel;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;

public class RedThreadRenderer<T extends RedThreadBlockEntity>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("red_thread.png");
    private final RedThreadModel redThreadModel;
    private static final RenderType GLOW = RenderType.m_173215_((String)"twilightforest:glow", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110661_(new RenderStateShard.CullStateShard(true)).m_110663_(new RenderStateShard.DepthTestStateShard("always", 519)).m_173292_(new RenderStateShard.ShaderStateShard(() -> TFShaders.RED_THREAD)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLoc, false, true)).m_110691_(true));

    public RedThreadRenderer(BlockEntityRendererProvider.Context context) {
        this.redThreadModel = new RedThreadModel(context.m_173582_(TFModelLayers.RED_THREAD));
    }

    public void render(T thread, float ticks, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
        BlockState state = thread.m_58900_();
        boolean glow = Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_21055_((Item)TFItems.RED_THREAD.get());
        for (Direction face : Direction.values()) {
            if (!((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(face))).booleanValue()) continue;
            poseStack.m_85836_();
            Vec3 xyz = RedThreadRenderer.getXYZ(face);
            poseStack.m_85837_(xyz.f_82479_, xyz.f_82480_, xyz.f_82481_);
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(RedThreadRenderer.getZPDegrees(face)));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(RedThreadRenderer.getXPDegrees(face)));
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0, 0.5);
            this.render(thread, face, poseStack, glow ? source.m_6299_(GLOW) : source.m_6299_(RenderType.m_110452_((ResourceLocation)textureLoc)), glow ? 0xF000F0 : light);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    private void render(T thread, Direction face, PoseStack poseStack, VertexConsumer consumer, int light) {
        Level level = thread.m_58904_();
        BlockPos pos = thread.m_58899_();
        this.redThreadModel.center.m_104306_(poseStack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_().equals((Object)face.m_122434_())) continue;
            boolean flag = (Boolean)thread.m_58900_().m_61143_((Property)PipeBlock.f_55154_.get(direction));
            if (!flag && level != null) {
                BlockState state = level.m_8055_(pos.m_121945_(direction));
                boolean bl = flag = state.m_60734_().equals(TFBlocks.RED_THREAD.get()) && (Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(face)) != false;
                if (!flag) {
                    state = level.m_8055_(pos.m_121945_(direction).m_121945_(face));
                    boolean threadBlocked = level.m_8055_(pos.m_121945_(direction)).m_60783_((BlockGetter)level, pos, direction.m_122424_());
                    boolean bl2 = flag = state.m_60734_().equals(TFBlocks.RED_THREAD.get()) && !threadBlocked && (Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(direction.m_122424_())) != false;
                }
            }
            if (!flag) continue;
            this.redThreadModel.getPart(face, direction).m_104306_(poseStack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static Vec3 getXYZ(Direction face) {
        return new Vec3(face == Direction.EAST || face == Direction.UP ? 1.0 : 0.0, face == Direction.WEST || face == Direction.UP || face == Direction.NORTH ? 1.0 : 0.0, face == Direction.SOUTH ? 1.0 : 0.0);
    }

    private static float getZPDegrees(Direction face) {
        return switch (face) {
            case Direction.EAST -> 90.0f;
            case Direction.UP -> 180.0f;
            case Direction.WEST -> 270.0f;
            default -> 0.0f;
        };
    }

    private static float getXPDegrees(Direction face) {
        return switch (face) {
            case Direction.NORTH -> 90.0f;
            case Direction.SOUTH -> 270.0f;
            default -> 0.0f;
        };
    }
}

