/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.data.custom.stalactites.entry.StalactiteReloadListener;

public abstract class StalactiteProvider
implements DataProvider {
    private final DataGenerator generator;
    private final String modid;
    private final DataGenerator.PathProvider entryPath;
    protected final Map<Pair<ResourceLocation, Stalactite>, Stalactite.HollowHillType> builder = Maps.newLinkedHashMap();

    public StalactiteProvider(DataGenerator generator, String modid) {
        this.generator = generator;
        this.modid = modid;
        this.entryPath = generator.m_236036_(DataGenerator.Target.DATA_PACK, "stalactites/entries");
    }

    public void m_213708_(CachedOutput output) throws IOException {
        HashMap map = Maps.newHashMap();
        HashMap smallHillEntries = Maps.newHashMap();
        HashMap medHillEntries = Maps.newHashMap();
        HashMap largeHillEntries = Maps.newHashMap();
        this.builder.clear();
        this.createStalactites();
        this.builder.forEach((stalactiteMap, type) -> {
            if (type == Stalactite.HollowHillType.LARGE) {
                largeHillEntries.put((ResourceLocation)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            } else if (type == Stalactite.HollowHillType.MEDIUM) {
                medHillEntries.put((ResourceLocation)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            } else {
                smallHillEntries.put((ResourceLocation)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            }
            map.put((ResourceLocation)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
        });
        map.forEach((resourceLocation, stalactite) -> {
            Path path = this.entryPath.m_236048_(resourceLocation);
            try {
                DataProvider.m_236072_((CachedOutput)output, (JsonElement)StalactiteReloadListener.serialize(stalactite), (Path)path);
            }
            catch (IOException ioexception) {
                TwilightForestMod.LOGGER.error("Couldn't save stalactite entry {}", (Object)path, (Object)ioexception);
            }
        });
        Gson hillGson = new GsonBuilder().setPrettyPrinting().create();
        for (Stalactite.HollowHillType type2 : Stalactite.HollowHillType.values()) {
            Path hillPath = this.generator.m_123916_().resolve("data/twilightforest/stalactites/" + type2.name().toLowerCase(Locale.ROOT) + "_hollow_hill.json");
            HashMap mapToUse = type2 == Stalactite.HollowHillType.LARGE ? largeHillEntries : (type2 == Stalactite.HollowHillType.MEDIUM ? medHillEntries : smallHillEntries);
            JsonObject object = new JsonObject();
            object.addProperty("replace", Boolean.valueOf(false));
            object.add("stalactites", hillGson.toJsonTree(mapToUse.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList())));
            DataProvider.m_236072_((CachedOutput)output, (JsonElement)object, (Path)hillPath);
        }
    }

    protected abstract void createStalactites();

    protected void makeStalactite(Stalactite stalactite, Stalactite.HollowHillType type) {
        this.builder.putIfAbsent((Pair<ResourceLocation, Stalactite>)Pair.of((Object)new ResourceLocation(this.modid, ForgeRegistries.BLOCKS.getKey((Object)stalactite.ore()).m_135815_() + "_stalactite"), (Object)stalactite), type);
    }

    public String m_6055_() {
        return this.modid + " Hollow Hill Stalactites";
    }
}

