/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites.entry;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.data.custom.stalactites.entry.StalactiteReloadListener;

public record Stalactite(Block ore, float sizeVariation, int maxLength, int weight) {
    private static StalactiteReloadListener STALACTITE_CONFIG;

    public static void reloadStalactites(AddReloadListenerEvent event) {
        STALACTITE_CONFIG = new StalactiteReloadListener();
        event.addListener((PreparableReloadListener)STALACTITE_CONFIG);
    }

    public static StalactiteReloadListener getStalactiteConfig() {
        if (STALACTITE_CONFIG == null) {
            throw new IllegalStateException("Can not retrieve Stalactites yet!");
        }
        return STALACTITE_CONFIG;
    }

    public static enum HollowHillType {
        SMALL,
        MEDIUM,
        LARGE;

    }

    public static class Serializer
    implements JsonDeserializer<Stalactite>,
    JsonSerializer<Stalactite> {
        public Stalactite deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)json, (String)"stalactite");
            String block = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"ore");
            if (ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)block)) == null) {
                throw new JsonParseException("Block " + block + " defined in Stalactite config does not exist!");
            }
            Block ore = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)block));
            float size = GsonHelper.m_13915_((JsonObject)jsonobject, (String)"size_variation");
            int maxLength = GsonHelper.m_13927_((JsonObject)jsonobject, (String)"max_length");
            int weight = GsonHelper.m_13927_((JsonObject)jsonobject, (String)"weight");
            return new Stalactite(ore, size, maxLength, weight);
        }

        public JsonElement serialize(Stalactite stalactite, Type type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.add("ore", context.serialize((Object)ForgeRegistries.BLOCKS.getKey((Object)stalactite.ore()).toString()));
            jsonobject.add("size_variation", context.serialize((Object)Float.valueOf(stalactite.sizeVariation())));
            jsonobject.add("max_length", context.serialize((Object)stalactite.maxLength()));
            jsonobject.add("weight", context.serialize((Object)stalactite.weight()));
            return jsonobject;
        }
    }
}

