/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.IBreathAttacker;

public class BreathAttackGoal<T extends Mob>
extends Goal {
    private final T entityHost;
    private LivingEntity attackTarget;
    private Vec3 breathPos;
    private final int maxDuration;
    private final float attackChance;
    private final float breathRange;
    private int durationLeft;

    public BreathAttackGoal(T living, float range, int time, float chance) {
        this.entityHost = living;
        this.breathRange = range;
        this.maxDuration = time;
        this.attackChance = chance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        this.attackTarget = this.entityHost.m_21188_();
        if (this.attackTarget == null || this.entityHost.m_20270_((Entity)this.attackTarget) > this.breathRange || !this.entityHost.m_21574_().m_148306_((Entity)this.attackTarget) || !EntitySelector.f_20406_.and(EntitySelector.f_20403_).test(this.attackTarget)) {
            return false;
        }
        this.breathPos = this.attackTarget.m_146892_();
        return this.entityHost.m_217043_().m_188501_() < this.attackChance;
    }

    public void m_8056_() {
        this.durationLeft = this.maxDuration;
        ((IBreathAttacker)this.entityHost).setBreathing(true);
    }

    public boolean m_8045_() {
        return this.durationLeft > 0 && this.entityHost.m_6084_() && this.attackTarget.m_6084_() && this.entityHost.m_20270_((Entity)this.attackTarget) <= this.breathRange && this.entityHost.m_21574_().m_148306_((Entity)this.attackTarget) && EntitySelector.f_20406_.and(EntitySelector.f_20403_).test(this.attackTarget);
    }

    public void m_8037_() {
        Entity target;
        --this.durationLeft;
        this.entityHost.m_21563_().m_24964_(this.breathPos);
        this.faceVec(this.breathPos, 100.0f, 100.0f);
        if (this.maxDuration - this.durationLeft > 5 && (target = this.getHeadLookTarget()) != null) {
            ((IBreathAttacker)this.entityHost).doBreathAttack(target);
            this.entityHost.m_146850_(GameEvent.f_157778_);
        }
    }

    public void m_8041_() {
        this.durationLeft = 0;
        this.attackTarget = null;
        ((IBreathAttacker)this.entityHost).setBreathing(false);
    }

    @Nullable
    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 30.0;
        double offset = 3.0;
        Vec3 srcVec = new Vec3(this.entityHost.m_20185_(), this.entityHost.m_20186_() + 0.25, this.entityHost.m_20189_());
        Vec3 lookVec = this.entityHost.m_20252_(1.0f);
        Vec3 destVec = srcVec.m_82520_(lookVec.m_7096_() * range, lookVec.m_7098_() * range, lookVec.m_7094_() * range);
        float var9 = 0.5f;
        List possibleList = this.entityHost.m_9236_().m_45933_(this.entityHost, this.entityHost.m_20191_().m_82386_(lookVec.m_7096_() * offset, lookVec.m_7098_() * offset, lookVec.m_7094_() * offset).m_82377_((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        if (this.entityHost.isMultipartEntity()) {
            possibleList.removeAll(Arrays.asList(Objects.requireNonNull(this.entityHost.getParts())));
        }
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.m_6087_() || possibleEntity == this.entityHost || !EntitySelector.f_20406_.and(EntitySelector.f_20403_).test(possibleEntity)) continue;
            float borderSize = possibleEntity.m_6143_();
            AABB collisionBB = possibleEntity.m_20191_().m_82377_((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
            if (collisionBB.m_82390_(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.m_82554_((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void faceVec(Vec3 pos, float yawConstraint, float pitchConstraint) {
        double xOffset = pos.m_7096_() - this.entityHost.m_20185_();
        double zOffset = pos.m_7094_() - this.entityHost.m_20189_();
        double yOffset = this.entityHost.m_20186_() + 0.25 - pos.m_7098_();
        double distance = Mth.m_14116_((float)((float)(xOffset * xOffset + zOffset * zOffset)));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        this.entityHost.m_146926_(-this.updateRotation(this.entityHost.m_146909_(), zdAngle, pitchConstraint));
        this.entityHost.m_146922_(this.updateRotation(this.entityHost.m_146908_(), xyAngle, yawConstraint));
    }

    private float updateRotation(float current, float target, float maxDelta) {
        float delta = Mth.m_14177_((float)(target - current));
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (delta < -maxDelta) {
            delta = -maxDelta;
        }
        return current + delta;
    }
}

