/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;

public class Bighorn
extends Sheep {
    public Bighorn(EntityType<? extends Bighorn> type, Level world) {
        super(type, world);
    }

    public Bighorn(Level world, double x, double y, double z) {
        this((EntityType<? extends Bighorn>)((EntityType)TFEntities.BIGHORN_SHEEP.get()), world);
        this.m_6034_(x, y, z);
    }

    public ResourceLocation m_7582_() {
        if (this.m_29875_()) {
            return this.m_6095_().m_20677_();
        }
        return switch (this.m_29874_()) {
            case DyeColor.ORANGE -> TFLootTables.BIGHORN_SHEEP_ORANGE;
            case DyeColor.MAGENTA -> TFLootTables.BIGHORN_SHEEP_MAGENTA;
            case DyeColor.LIGHT_BLUE -> TFLootTables.BIGHORN_SHEEP_LIGHT_BLUE;
            case DyeColor.YELLOW -> TFLootTables.BIGHORN_SHEEP_YELLOW;
            case DyeColor.LIME -> TFLootTables.BIGHORN_SHEEP_LIME;
            case DyeColor.PINK -> TFLootTables.BIGHORN_SHEEP_PINK;
            case DyeColor.GRAY -> TFLootTables.BIGHORN_SHEEP_GRAY;
            case DyeColor.LIGHT_GRAY -> TFLootTables.BIGHORN_SHEEP_LIGHT_GRAY;
            case DyeColor.CYAN -> TFLootTables.BIGHORN_SHEEP_CYAN;
            case DyeColor.PURPLE -> TFLootTables.BIGHORN_SHEEP_PURPLE;
            case DyeColor.BLUE -> TFLootTables.BIGHORN_SHEEP_BLUE;
            case DyeColor.BROWN -> TFLootTables.BIGHORN_SHEEP_BROWN;
            case DyeColor.GREEN -> TFLootTables.BIGHORN_SHEEP_GREEN;
            case DyeColor.RED -> TFLootTables.BIGHORN_SHEEP_RED;
            case DyeColor.BLACK -> TFLootTables.BIGHORN_SHEEP_BLACK;
            default -> TFLootTables.BIGHORN_SHEEP_WHITE;
        };
    }

    private static DyeColor getRandomFleeceColor(RandomSource random) {
        return random.m_188499_() ? DyeColor.BROWN : DyeColor.m_41053_((int)random.m_188503_(16));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag dataTag) {
        livingdata = super.m_6518_(accessor, difficulty, reason, livingdata, dataTag);
        this.m_29855_(Bighorn.getRandomFleeceColor(accessor.m_213780_()));
        return livingdata;
    }

    public Sheep m_142606_(ServerLevel world, AgeableMob ageable) {
        if (!(ageable instanceof Bighorn)) {
            TwilightForestMod.LOGGER.error("Code was called to breed a Bighorn with a non Bighorn! Cancelling!");
            return null;
        }
        Bighorn otherParent = (Bighorn)ageable;
        Bighorn babySheep = (Bighorn)((EntityType)TFEntities.BIGHORN_SHEEP.get()).m_20615_((Level)world);
        babySheep.m_29855_(this.m_29823_((Animal)this, (Animal)otherParent));
        return babySheep;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.BIGHORN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.BIGHORN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.BIGHORN_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)TFSounds.BIGHORN_STEP.get(), 0.15f, 1.0f);
    }
}

