/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.util.FeatureLogic;

public class BlockSpikeFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Stalactite STONE_STALACTITE = new Stalactite(Blocks.f_50069_, 0.25f, 11, 1);

    public BlockSpikeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.m_225041_();
        return BlockSpikeFeature.startSpike(context.m_159774_(), context.m_159777_(), STONE_STALACTITE, random, false);
    }

    public static boolean startSpike(WorldGenLevel level, BlockPos startPos, Stalactite config, RandomSource random, boolean hanging) {
        UniformInt lengthBounds = UniformInt.m_146622_((int)((int)((float)config.maxLength() * config.sizeVariation())), (int)config.maxLength());
        return BlockSpikeFeature.startSpike(level, startPos, config.ore(), lengthBounds.m_214085_(random), lengthBounds.m_142739_(), ConstantInt.m_146483_((int)4).m_214085_(random), hanging, random);
    }

    public static boolean startSpike(WorldGenLevel level, BlockPos startPos, Block ore, int length, int lengthMinimum, int clearance, boolean hang, RandomSource random) {
        BlockPos.MutableBlockPos movingPos = startPos.m_122032_();
        int clearedLength = 0;
        int dY = hang ? -1 : 1;
        int i = 0;
        while (i < length) {
            clearedLength = i++;
            if (FeatureLogic.worldGenReplaceable(level.m_8055_((BlockPos)movingPos))) break;
            movingPos.m_122184_(0, dY, 0);
        }
        movingPos.m_122184_(0, dY, 0);
        int remainingScanLength = length - clearedLength + clearance;
        int finalLength = clearedLength - clearance;
        for (int i2 = 0; i2 < remainingScanLength; ++i2) {
            finalLength = clearedLength + i2;
            if (!FeatureLogic.worldGenReplaceable(level.m_8055_((BlockPos)movingPos))) break;
            movingPos.m_122184_(0, dY, 0);
        }
        if ((finalLength = Math.min(length, finalLength)) < lengthMinimum) {
            return false;
        }
        return BlockSpikeFeature.makeSpike(level, startPos, ore, finalLength, dY, random, hang);
    }

    private static boolean makeSpike(WorldGenLevel level, BlockPos startPos, Block ore, int length, int dY, RandomSource random, boolean hang) {
        int diameter = (int)((float)length / 4.5f);
        if (!hang && !FeatureLogic.worldGenReplaceable(level.m_8055_(startPos.m_7495_()))) {
            return false;
        }
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int absz;
                int absx = Math.abs(dx);
                int dist = (int)((float)Math.max(absx, absz = Math.abs(dz)) + (float)Math.min(absx, absz) * 0.5f);
                int spikeLength = dist <= 0 ? length : random.m_188503_((int)((float)length / ((float)dist + 0.25f)));
                for (int i = -1; i < spikeLength; ++i) {
                    BlockPos placement = startPos.m_7918_(dx, i * dY, dz);
                    if (!FeatureLogic.worldGenReplaceable(level.m_8055_(placement)) || dY <= 0 && placement.m_123342_() >= level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, placement.m_123341_(), placement.m_123343_()) - 1) continue;
                    level.m_7731_(placement, ore.m_49966_(), 3);
                }
            }
        }
        return true;
    }

    public static Stalactite makeRandomOreStalactite(RandomSource rand, int hillSize) {
        if (hillSize >= 3 && rand.m_188503_(5) == 0) {
            return Stalactite.getStalactiteConfig().getRandomStalactiteFromList(rand, Stalactite.getStalactiteConfig().getLargeStalactites());
        }
        if (hillSize >= 2 && rand.m_188503_(5) == 0) {
            return Stalactite.getStalactiteConfig().getRandomStalactiteFromList(rand, Stalactite.getStalactiteConfig().getMediumStalactites());
        }
        return Stalactite.getStalactiteConfig().getRandomStalactiteFromList(rand, Stalactite.getStalactiteConfig().getSmallStalactites());
    }
}

