/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.templates;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.loot.TFLootTables;
import twilightforest.world.components.feature.templates.TemplateFeature;
import twilightforest.world.components.processors.CobblePlankSwizzler;
import twilightforest.world.components.processors.CobbleVariants;
import twilightforest.world.components.processors.SmartGrassProcessor;
import twilightforest.world.components.processors.StoneBricksVariants;

public class FancyWellFeature
extends TemplateFeature<NoneFeatureConfiguration> {
    private static final ResourceLocation WELL_TOP = TwilightForestMod.prefix("feature/well/fancy_well_top");
    private static final ResourceLocation WELL_BOTTOM = TwilightForestMod.prefix("feature/well/fancy_well_bottom");

    public FancyWellFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    @Override
    @Nullable
    protected StructureTemplate getTemplate(StructureTemplateManager templateManager, RandomSource random) {
        return templateManager.m_230359_(WELL_TOP);
    }

    @Override
    protected void modifySettings(StructurePlaceSettings settings, RandomSource random) {
        settings.m_74383_((StructureProcessor)new CobblePlankSwizzler(random)).m_74383_((StructureProcessor)CobbleVariants.INSTANCE).m_74383_((StructureProcessor)StoneBricksVariants.INSTANCE);
    }

    @Override
    protected void postPlacement(WorldGenLevel world, RandomSource random, StructureTemplateManager templateManager, Rotation rotation, Mirror mirror, StructurePlaceSettings placementSettings, BlockPos placementPos) {
        StructureTemplate template = templateManager.m_230359_(WELL_BOTTOM);
        if (template == null) {
            return;
        }
        placementPos = placementPos.m_6625_(template.m_163801_().m_123342_());
        placementSettings.m_74383_((StructureProcessor)SmartGrassProcessor.INSTANCE);
        template.m_230328_((ServerLevelAccessor)world, placementPos, placementPos, placementSettings, random, 20);
        for (StructureTemplate.StructureBlockInfo info : template.m_74603_(placementPos, placementSettings, Blocks.f_50677_)) {
            if (info.f_74677_ == null || StructureMode.valueOf((String)info.f_74677_.m_128461_("mode")) != StructureMode.DATA) continue;
            this.processMarkers(info, world, rotation, mirror, random);
        }
    }

    @Override
    protected void processMarkers(StructureTemplate.StructureBlockInfo info, WorldGenLevel world, Rotation rotation, Mirror mirror, RandomSource random) {
        String s = info.f_74677_.m_128461_("metadata");
        if (!s.startsWith("loot")) {
            return;
        }
        world.m_7471_(info.f_74675_, false);
        TFLootTables.FANCY_WELL.generateLootContainer(world, info.f_74675_, (BlockState)Blocks.f_50618_.m_49966_().m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.UP), 18);
    }
}

