/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.init.TFEntities;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.loot.TFLootTables;
import twilightforest.world.components.feature.BlockSpikeFeature;
import twilightforest.world.components.structures.TFStructureComponentOld;

public class HollowHillComponent
extends TFStructureComponentOld {
    private static final int[] stalactitesForSizes = new int[]{0, 128, 256, 512};
    private static final int[] spawnersForSizes = new int[]{0, 1, 4, 9};
    private static final int[] chestsForSizes = new int[]{0, 2, 6, 12};
    private final int hillSize;
    final int radius;
    final int hdiam;

    public HollowHillComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        this((StructurePieceType)TFStructurePieceTypes.TFHill.get(), nbt);
    }

    public HollowHillComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.hillSize = nbt.m_128451_("hillSize");
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.hdiam = (this.hillSize * 2 + 1) * 16;
    }

    public HollowHillComponent(StructurePieceType piece, TFLandmark feature, int i, int size, int x, int y, int z) {
        super(piece, feature, i, x, y, z);
        this.m_73519_(Direction.SOUTH);
        this.hillSize = size;
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.hdiam = (this.hillSize * 2 + 1) * 16;
        this.f_73383_ = feature.getComponentToAddBoundingBox(x, y, z, -this.radius, -(3 + this.hillSize), -this.radius, this.radius * 2, this.radius / (this.hillSize == 1 ? 2 : this.hillSize), this.radius * 2, Direction.SOUTH);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128405_("hillSize", this.hillSize);
    }

    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockPos.MutableBlockPos dest;
        int i;
        int stalactiteCount = stalactitesForSizes[this.hillSize];
        for (i = 0; i < stalactiteCount; ++i) {
            dest = this.randomCeilingCoordinates(rand, this.radius);
            this.generateOreStalactite(world, (Vec3i)dest.m_122184_(0, 1, 0), sbb);
        }
        for (i = 0; i < stalactiteCount; ++i) {
            dest = this.randomCeilingCoordinates(rand, this.radius);
            this.generateBlockSpike(world, BlockSpikeFeature.STONE_STALACTITE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb, true);
        }
        for (i = 0; i < stalactiteCount; ++i) {
            dest = this.randomFloorCoordinates(rand, this.radius);
            this.generateBlockSpike(world, BlockSpikeFeature.STONE_STALACTITE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb, false);
        }
        for (i = 0; i < spawnersForSizes[this.hillSize]; ++i) {
            dest = this.randomFloorCoordinates(rand, this.radius);
            EntityType<?> mobID = this.getMobID(rand);
            this.setSpawner(world, (Vec3i)dest.m_122184_(0, 1, 0), sbb, mobID);
        }
        for (i = 0; i < chestsForSizes[this.hillSize]; ++i) {
            dest = this.randomFloorCoordinates(rand, this.radius);
            this.generateTreasureChest(world, (Vec3i)dest.m_122184_(0, 1, 0), sbb);
        }
    }

    protected void generateTreasureChest(WorldGenLevel world, Vec3i pos, BoundingBox sbb) {
        this.generateTreasureChest(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), sbb);
    }

    protected void generateTreasureChest(WorldGenLevel world, int x, int y, int z, BoundingBox sbb) {
        RandomSource chestRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)x * (long)z));
        this.placeTreasureAtCurrentPosition(world, x, y, z, this.hillSize == 3 ? TFLootTables.LARGE_HOLLOW_HILL : (this.hillSize == 2 ? TFLootTables.MEDIUM_HOLLOW_HILL : TFLootTables.SMALL_HOLLOW_HILL), sbb);
        this.m_73434_(world, Blocks.f_50652_.m_49966_(), x, y - 1, z, sbb);
    }

    protected void generateOreStalactite(WorldGenLevel world, Vec3i pos, BoundingBox sbb) {
        this.generateOreStalactite(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), sbb);
    }

    protected void generateOreStalactite(WorldGenLevel world, int x, int y, int z, BoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos) && world.m_8055_(pos).m_60734_() != Blocks.f_50085_) {
            RandomSource stalRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)dx * (long)dz));
            Stalactite stalag = BlockSpikeFeature.makeRandomOreStalactite(stalRNG, this.hillSize);
            BlockSpikeFeature.startSpike(world, pos, stalag, stalRNG, true);
        }
    }

    protected void generateBlockSpike(WorldGenLevel world, Stalactite config, int x, int y, int z, BoundingBox sbb, boolean hanging) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos) && world.m_8055_(pos).m_60734_() != Blocks.f_50085_) {
            RandomSource stalRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)dx * (long)dz));
            BlockSpikeFeature.startSpike(world, pos, config, stalRNG, hanging);
        }
    }

    boolean isInHill(int cx, int cz) {
        int dx = this.radius - cx;
        int dz = this.radius - cz;
        return Mth.m_14116_((float)(dx * dx + dz * dz)) < (float)this.radius;
    }

    @Deprecated
    int[] randomCoordinatesInHill2D(RandomSource rand) {
        return this.randomCoordinatesInHill2D(rand, this.radius);
    }

    @Deprecated
    int[] randomCoordinatesInHill2D(RandomSource rand, int maximumRadius) {
        BlockPos.MutableBlockPos pos = this.randomFloorCoordinates(rand, maximumRadius);
        return new int[]{pos.m_123341_(), pos.m_123343_()};
    }

    BlockPos.MutableBlockPos randomFloorCoordinates(RandomSource rand, float maximumRadius) {
        float degree = rand.m_188501_() * ((float)Math.PI * 2);
        float radius = rand.m_188501_() * 0.9f * maximumRadius;
        float dist = Mth.m_14116_((float)(radius * radius));
        float height = (float)(this.hillSize * 2) - Mth.m_14089_((float)(dist / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 20.0f) + 1.0f;
        return new BlockPos.MutableBlockPos((double)(maximumRadius - Mth.m_14089_((float)degree) * radius), (double)height, (double)(maximumRadius - Mth.m_14031_((float)degree) * radius));
    }

    BlockPos.MutableBlockPos randomCeilingCoordinates(RandomSource rand, float maximumRadius) {
        float degree = rand.m_188501_() * ((float)Math.PI * 2);
        float radius = rand.m_188501_() * 0.9f * maximumRadius;
        float dist = Mth.m_14116_((float)(radius * radius));
        float height = Mth.m_14089_((float)(dist / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 4.0f);
        return new BlockPos.MutableBlockPos((double)(maximumRadius - Mth.m_14089_((float)degree) * radius), (double)height, (double)(maximumRadius - Mth.m_14031_((float)degree) * radius));
    }

    protected EntityType<?> getMobID(RandomSource rand) {
        return this.getMobID(rand, this.hillSize);
    }

    protected EntityType<?> getMobID(RandomSource rand, int level) {
        if (level == 1) {
            return this.getLevel1Mob(rand);
        }
        if (level == 2) {
            return this.getLevel2Mob(rand);
        }
        if (level == 3) {
            return this.getLevel3Mob(rand);
        }
        return EntityType.f_20479_;
    }

    public EntityType<?> getLevel1Mob(RandomSource rand) {
        return switch (rand.m_188503_(10)) {
            case 3, 4, 5 -> EntityType.f_20479_;
            case 6, 7 -> EntityType.f_20501_;
            case 8 -> EntityType.f_20523_;
            case 9 -> (EntityType)TFEntities.REDCAP.get();
            default -> (EntityType)TFEntities.SWARM_SPIDER.get();
        };
    }

    public EntityType<?> getLevel2Mob(RandomSource rand) {
        return switch (rand.m_188503_(10)) {
            case 3, 4, 5 -> EntityType.f_20501_;
            case 6, 7 -> EntityType.f_20524_;
            case 8 -> (EntityType)TFEntities.SWARM_SPIDER.get();
            case 9 -> EntityType.f_20554_;
            default -> (EntityType)TFEntities.REDCAP.get();
        };
    }

    public EntityType<?> getLevel3Mob(RandomSource rand) {
        return switch (rand.m_188503_(11)) {
            case 0 -> (EntityType)TFEntities.SLIME_BEETLE.get();
            case 1 -> (EntityType)TFEntities.FIRE_BEETLE.get();
            case 2 -> (EntityType)TFEntities.PINCH_BEETLE.get();
            case 3, 4, 5 -> EntityType.f_20524_;
            case 6, 7, 8 -> EntityType.f_20554_;
            case 9 -> EntityType.f_20558_;
            default -> (EntityType)TFEntities.WRAITH.get();
        };
    }
}

