/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.icetower;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.icetower.IceTowerWingComponent;

public class IceTowerBossWingComponent
extends IceTowerWingComponent {
    public IceTowerBossWingComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFITBoss.get(), nbt);
        this.spawnListIndex = -1;
    }

    public IceTowerBossWingComponent(TFLandmark feature, int index, int x, int y, int z, int wingSize, int wingHeight, Direction direction) {
        super((StructurePieceType)TFStructurePieceTypes.TFITBoss.get(), feature, index, x, y, z, wingSize, wingHeight, direction);
        this.spawnListIndex = -1;
    }

    @Override
    protected boolean shouldHaveBase(RandomSource rand) {
        return false;
    }

    @Override
    protected void placeFloor(WorldGenLevel world, RandomSource rand, BoundingBox sbb, int floorHeight, int floor) {
        for (int x = 1; x < this.size - 1; ++x) {
            for (int z = 1; z < this.size - 1; ++z) {
                BlockState ice = (rand.m_188503_(4) == 0 ? Blocks.f_50126_ : Blocks.f_50354_).m_49966_();
                int thickness = 1 + rand.m_188503_(2) + rand.m_188503_(2) + rand.m_188503_(2);
                for (int y = 0; y < thickness; ++y) {
                    this.m_73434_(world, ice, x, floor * floorHeight + floorHeight - y, z, sbb);
                }
            }
        }
    }

    @Override
    protected void decorateFloor(WorldGenLevel world, RandomSource rand, int floor, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, BoundingBox sbb) {
        Rotation r = ladderDownDir;
        for (int y = 0; y < 3; ++y) {
            this.placeIceStairs(world, sbb, rand, bottom + y * 3, r);
            this.placeIceStairs(world, sbb, rand, bottom + y * 3, r.m_55952_(Rotation.CLOCKWISE_180));
            r = r.m_55952_(Rotation.CLOCKWISE_90);
        }
    }

    private void placeIceStairs(WorldGenLevel world, BoundingBox sbb, RandomSource rand, int y, Rotation rotation) {
        BlockState packedIce = Blocks.f_50354_.m_49966_();
        this.fillBlocksRotated(world, sbb, 8, y + 1, 1, 10, y + 1, 3, packedIce, rotation);
        if (y > 1) {
            this.randomlyFillBlocksRotated(world, sbb, rand, 0.5f, 8, y, 1, 10, y, 3, packedIce, AIR, rotation);
        }
        this.fillBlocksRotated(world, sbb, 11, y + 2, 1, 13, y + 2, 3, packedIce, rotation);
        this.randomlyFillBlocksRotated(world, sbb, rand, 0.5f, 11, y + 1, 1, 13, y + 1, 3, packedIce, AIR, rotation);
        this.fillBlocksRotated(world, sbb, 11, y + 3, 4, 13, y + 3, 6, packedIce, rotation);
        this.randomlyFillBlocksRotated(world, sbb, rand, 0.5f, 11, y + 2, 4, 13, y + 2, 6, packedIce, AIR, rotation);
    }

    @Override
    protected void decorateTopFloor(WorldGenLevel world, RandomSource rand, int floor, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, BoundingBox sbb) {
        for (int x = 1; x < this.size - 1; ++x) {
            for (int z = 1; z < this.size - 1; ++z) {
                BlockState ice = (rand.m_188503_(10) == 0 ? Blocks.f_50141_ : Blocks.f_50354_).m_49966_();
                int thickness = rand.m_188503_(2) + rand.m_188503_(2);
                for (int y = 0; y < thickness; ++y) {
                    this.m_73434_(world, ice, x, top - 1 - y, z, sbb);
                }
            }
        }
        BlockState snowQueenSpawner = ((Block)TFBlocks.SNOW_QUEEN_BOSS_SPAWNER.get()).m_49966_();
        this.setBlockStateRotated(world, snowQueenSpawner, 7, top - 6, 7, Rotation.NONE, sbb);
        this.m_73535_(world, sbb, 5, top - 3, 5, 9, top - 1, 9);
    }
}

