/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtower;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.lichtower.TowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class TowerRoofSlabComponent
extends TowerRoofComponent {
    public TowerRoofSlabComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFLTRS.get(), nbt);
    }

    public TowerRoofSlabComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
    }

    public TowerRoofSlabComponent(StructurePieceType piece, TFLandmark feature, int i, TowerWingComponent wing, int x, int y, int z) {
        super(piece, feature, i, x, y, z);
        this.m_73519_(wing.m_73549_());
        this.size = wing.size;
        this.height = this.size / 2;
        this.makeCapBB(wing);
    }

    @Override
    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.makePyramidCap(world, Blocks.f_50400_.m_49966_(), Blocks.f_50742_.m_49966_(), sbb);
    }

    protected void makePyramidCap(WorldGenLevel world, BlockState slabType, BlockState woodType, BoundingBox sbb) {
        for (int y = 0; y <= this.height; ++y) {
            int min = 2 * y;
            int max = this.size - 2 * y - 1;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x == min || x == max || z == min || z == max) {
                        this.m_73434_(world, slabType, x, y, z, sbb);
                        continue;
                    }
                    this.m_73434_(world, woodType, x, y, z, sbb);
                }
            }
        }
    }

    protected void makeConnectedCap(WorldGenLevel world, BlockState slabType, BlockState woodType, BoundingBox sbb) {
        for (int y = 0; y < this.height; ++y) {
            int min = 2 * y;
            int max = this.size - 2 * y - 1;
            for (int x = 0; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x == max || z == min || z == max) {
                        this.m_73434_(world, slabType, x, y, z, sbb);
                        continue;
                    }
                    this.m_73434_(world, woodType, x, y, z, sbb);
                }
            }
        }
    }
}

