/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.minotaurmaze;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.HugeMushroomUtil;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomComponent;

public class MazeMushRoomComponent
extends MazeRoomComponent {
    public MazeMushRoomComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFMMMR.get(), nbt);
    }

    public MazeMushRoomComponent(TFLandmark feature, int i, RandomSource rand, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFMMMR.get(), feature, i, rand, x, y, z);
        this.m_73519_(Direction.SOUTH);
    }

    @Override
    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        super.m_213694_(world, manager, generator, rand, sbb, chunkPosIn, blockPos);
        for (int x = 1; x < 14; ++x) {
            for (int z = 1; z < 14; ++z) {
                int dist = (int)Math.round(7.0 / Math.sqrt((7.5 - (double)x) * (7.5 - (double)x) + (7.5 - (double)z) * (7.5 - (double)z)));
                if (rand.m_188503_(dist + 1) > 0) {
                    this.m_73434_(world, Blocks.f_50195_.m_49966_(), x, 0, z, sbb);
                }
                if (rand.m_188503_(dist) <= 0) continue;
                this.m_73434_(world, (rand.m_188499_() ? Blocks.f_50073_ : Blocks.f_50072_).m_49966_(), x, 1, z, sbb);
            }
        }
        BlockState redMushroomBlock = Blocks.f_50181_.m_49966_();
        BlockState brownMushroomBlock = Blocks.f_50180_.m_49966_();
        BlockState stemMushroomBlock = Blocks.f_50182_.m_49966_();
        this.makeMediumMushroom(world, sbb, 5, 2, 9, redMushroomBlock);
        this.makeMediumMushroom(world, sbb, 5, 3, 9, redMushroomBlock);
        this.makeMediumMushroom(world, sbb, 9, 2, 5, redMushroomBlock);
        this.makeMediumMushroom(world, sbb, 6, 3, 4, brownMushroomBlock);
        this.makeMediumMushroom(world, sbb, 10, 1, 9, brownMushroomBlock);
        this.m_73434_(world, stemMushroomBlock, 1, 2, 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.CENTER, redMushroomBlock), 1, 3, 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.NORTH_WEST, redMushroomBlock), 2, 3, 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.NORTH_WEST, redMushroomBlock), 1, 3, 2, sbb);
        this.m_73434_(world, stemMushroomBlock, 14, 3, 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.CENTER, brownMushroomBlock), 14, 4, 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.NORTH_EAST, brownMushroomBlock), 13, 4, 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.NORTH_EAST, brownMushroomBlock), 14, 4, 2, sbb);
        this.m_73434_(world, stemMushroomBlock, 1, 1, 14, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.CENTER, brownMushroomBlock), 1, 2, 14, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.SOUTH_WEST, brownMushroomBlock), 2, 2, 14, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.SOUTH_WEST, brownMushroomBlock), 1, 2, 13, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.CENTER, brownMushroomBlock), 14, 1, 14, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.SOUTH_EAST, brownMushroomBlock), 13, 1, 14, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.SOUTH_EAST, brownMushroomBlock), 14, 1, 13, sbb);
    }

    private void makeMediumMushroom(WorldGenLevel world, BoundingBox sbb, int mx, int my, int mz, BlockState redMushroomBlock) {
        BlockState mushroomStem = (BlockState)((BlockState)Blocks.f_50182_.m_49966_().m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(false));
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.CENTER, redMushroomBlock), mx, my, mz, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.WEST, redMushroomBlock), mx + 1, my, mz, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.NORTH_WEST, redMushroomBlock), mx + 1, my, mz + 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.NORTH, redMushroomBlock), mx, my, mz + 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.NORTH_EAST, redMushroomBlock), mx - 1, my, mz + 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.EAST, redMushroomBlock), mx - 1, my, mz, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.SOUTH_EAST, redMushroomBlock), mx - 1, my, mz - 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.SOUTH, redMushroomBlock), mx, my, mz - 1, sbb);
        this.m_73434_(world, HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.SOUTH_WEST, redMushroomBlock), mx + 1, my, mz - 1, sbb);
        for (int y = 1; y < my; ++y) {
            this.m_73434_(world, mushroomStem, mx, y, mz, sbb);
        }
    }
}

