/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePlacementTypes;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;

public class BiomeForcedLandmarkPlacement
extends StructurePlacement {
    public static final Codec<BiomeForcedLandmarkPlacement> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TFLandmark.CODEC.fieldOf("landmark_set").forGetter(p -> p.landmark), (App)Codec.intRange((int)-64, (int)256).fieldOf("scan_elevation").forGetter(p -> p.scanHeight)).apply((Applicative)inst, BiomeForcedLandmarkPlacement::new));
    private final TFLandmark landmark;
    private final int scanHeight;

    public BiomeForcedLandmarkPlacement(TFLandmark landmark, int biomeScanHeight) {
        super(Vec3i.f_123288_, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, 0, Optional.empty());
        this.landmark = landmark;
        this.scanHeight = biomeScanHeight;
    }

    public boolean m_227054_(ChunkGenerator chunkGenerator, RandomState randomState, long seed, int chunkX, int chunkZ) {
        return this.m_214090_(chunkGenerator, randomState, seed, chunkX, chunkZ);
    }

    public boolean m_214090_(ChunkGenerator chunkGenerator, RandomState randomState, long seed, int chunkX, int chunkZ) {
        if (chunkGenerator instanceof ChunkGeneratorTwilight) {
            ChunkGeneratorTwilight twilightGenerator = (ChunkGeneratorTwilight)chunkGenerator;
            return twilightGenerator.isLandmarkPickedForChunk(this.landmark, (Holder<Biome>)chunkGenerator.m_62218_().m_203407_(chunkX << 2, this.scanHeight, chunkZ << 2, randomState.m_224579_()), chunkX, chunkZ, seed);
        }
        if (!LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkX, chunkZ)) {
            return false;
        }
        return LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ, seed) == this.landmark;
    }

    public StructurePlacementType<?> m_203443_() {
        return (StructurePlacementType)TFStructurePlacementTypes.FORCED_LANDMARK_PLACEMENT_TYPE.get();
    }

    public TFLandmark getLandmark() {
        return this.landmark;
    }
}

