/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration.biomes;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectSortedMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import twilightforest.init.BiomeKeys;
import twilightforest.world.components.BiomeGrassColors;
import twilightforest.world.components.chunkgenerators.warp.TerrainColumn;
import twilightforest.world.registration.biomes.BiomeHelper;

public final class BiomeMaker
extends BiomeHelper {
    public static final Map<ResourceKey<Biome>, Biome> BIOMES = BiomeMaker.generateBiomes();

    public static List<TerrainColumn> makeBiomeList(Registry<Biome> biomeRegistry, Holder<Biome> undergroundBiome) {
        return List.of(BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, BiomeKeys.FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.1f, 0.2f, biomeRegistry, BiomeKeys.DENSE_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.0625f, 0.05f, biomeRegistry, BiomeKeys.FIREFLY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.005f, 0.005f, biomeRegistry, BiomeKeys.CLEARING, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.1f, biomeRegistry, BiomeKeys.OAK_SAVANNAH, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-1.65f, 0.25f, biomeRegistry, BiomeKeys.STREAM, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-1.97f, 0.0f, biomeRegistry, BiomeKeys.LAKE, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, BiomeKeys.MUSHROOM_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.05f, biomeRegistry, BiomeKeys.DENSE_MUSHROOM_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, BiomeKeys.ENCHANTED_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, BiomeKeys.SPOOKY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-0.9f, 0.15f, biomeRegistry, BiomeKeys.SWAMP, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-0.2f, 0.05f, biomeRegistry, BiomeKeys.FIRE_SWAMP, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.005f, biomeRegistry, BiomeKeys.DARK_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.005f, biomeRegistry, BiomeKeys.DARK_FOREST_CENTER, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.15f, biomeRegistry, BiomeKeys.SNOWY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, BiomeKeys.GLACIER, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(3.0f, 0.25f, biomeRegistry, BiomeKeys.HIGHLANDS, undergroundBiome), BiomeMaker.biomeColumnToBedrock(7.0f, 0.1f, biomeRegistry, BiomeKeys.THORNLANDS), BiomeMaker.biomeColumnToBedrock(13.75f, 0.025f, biomeRegistry, BiomeKeys.FINAL_PLATEAU));
    }

    private static TerrainColumn biomeColumnWithUnderground(float noiseDepth, float noiseScale, Registry<Biome> biomeRegistry, ResourceKey<Biome> key, Holder<Biome> undergroundBiome) {
        Holder.Reference biomeHolder = Holder.Reference.m_205766_(biomeRegistry, key);
        biomeHolder.m_205775_(key, (Object)BIOMES.get(key));
        return BiomeMaker.makeColumn(noiseDepth, noiseScale, (Holder<Biome>)biomeHolder, treeMap -> {
            treeMap.put(Math.min(noiseDepth - 1.0f, -1.0f), (Object)biomeHolder);
            treeMap.put(Math.min(noiseDepth - 3.0f, -3.0f), (Object)undergroundBiome);
        });
    }

    private static TerrainColumn biomeColumnToBedrock(float noiseDepth, float noiseScale, Registry<Biome> biomeRegistry, ResourceKey<Biome> key) {
        Holder.Reference biomeHolder = Holder.Reference.m_205766_(biomeRegistry, key);
        biomeHolder.m_205775_(key, (Object)BIOMES.get(key));
        return BiomeMaker.makeColumn(noiseDepth, noiseScale, (Holder<Biome>)biomeHolder, treeMap -> treeMap.put(0.0f, (Object)biomeHolder));
    }

    private static TerrainColumn makeColumn(float noiseDepth, float noiseScale, Holder<Biome> biomeHolder, Consumer<Float2ObjectSortedMap<Holder<Biome>>> layerBuilder) {
        return new TerrainColumn(biomeHolder, (Float2ObjectSortedMap<Holder<Biome>>)((Float2ObjectSortedMap)Util.m_137469_((Object)new Float2ObjectAVLTreeMap(), layerBuilder)), noiseDepth, noiseScale);
    }

    public static Holder<Biome> registerUnderground(Registry<Biome> registry, boolean fullRegister) {
        Holder.Reference holder = Holder.Reference.m_205766_(registry, BiomeKeys.UNDERGROUND);
        Biome underground = BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.undergroundMobSpawning(), BiomeMaker.undergroundGen()).m_47609_(0.7f).m_47611_(0.0f).m_47592_();
        if (fullRegister) {
            Registry.m_194579_(registry, BiomeKeys.UNDERGROUND, (Object)underground);
        }
        holder.m_205775_(BiomeKeys.UNDERGROUND, (Object)underground);
        return holder;
    }

    private static Map<ResourceKey<Biome>, Biome> generateBiomes() {
        ImmutableMap.Builder biomes = ImmutableMap.builder();
        BiomeMaker.commonBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.mushroomBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.rareBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.swampBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.darkForestBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.snowRegionBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.highlandsBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        return biomes.build();
    }

    private static void commonBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.twilightForestGen()).m_47592_());
        biomes.put(BiomeKeys.DENSE_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()).m_48034_(21794), BiomeMaker.defaultMobSpawning(), BiomeMaker.denseForestGen()).m_47609_(0.7f).m_47611_(0.8f).m_47592_());
        biomes.put(BiomeKeys.FIREFLY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyForestParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.fireflyForestGen()).m_47609_(0.5f).m_47611_(1.0f).m_47592_());
        biomes.put(BiomeKeys.CLEARING, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.clearingGen()).m_47609_(0.8f).m_47611_(0.4f).m_47592_());
        biomes.put(BiomeKeys.OAK_SAVANNAH, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.oakSavannaGen()).m_47609_(0.9f).m_47611_(0.0f).m_47592_());
    }

    private static void mushroomBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.MUSHROOM_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.mushroomForestGen()).m_47609_(0.8f).m_47611_(0.8f).m_47592_());
        biomes.put(BiomeKeys.DENSE_MUSHROOM_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.denseMushroomForestGen()).m_47609_(0.8f).m_47611_(1.0f).m_47592_());
    }

    private static void rareBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.SPOOKY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().m_48045_(12865827).m_48043_(16745729).m_48034_(12355671).m_48031_(BiomeGrassColors.SPOOKY_FOREST), BiomeMaker.spookSpawning(), BiomeMaker.spookyForestGen()).m_47609_(0.5f).m_47611_(1.0f).m_47592_());
        biomes.put(BiomeKeys.ENCHANTED_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()).m_48043_(65535).m_48045_(65535).m_48031_(BiomeGrassColors.ENCHANTED_FOREST), BiomeMaker.defaultMobSpawning(), BiomeMaker.enchantedForestGen()).m_47597_(Biome.Precipitation.NONE).m_47592_());
        biomes.put(BiomeKeys.STREAM, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.streamsAndLakes(false)).m_47609_(0.5f).m_47611_(0.1f).m_47592_());
        biomes.put(BiomeKeys.LAKE, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.streamsAndLakes(true)).m_47609_(0.66f).m_47611_(1.0f).m_47592_());
    }

    private static void swampBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.SWAMP, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().m_48040_(8466).m_48019_(16161).m_48045_(6056270).m_48043_(4809015).m_48034_(9811295).m_48031_(BiomeGrassColors.SWAMP), BiomeMaker.swampSpawning(), BiomeMaker.swampGen()).m_47609_(0.8f).m_47611_(0.9f).m_47592_());
        biomes.put(BiomeKeys.FIRE_SWAMP, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.whiteAshParticles(BiomeMaker.defaultAmbientBuilder()).m_48034_(2950912).m_48019_(3672576).m_48045_(5713443).m_48043_(6563343).m_48034_(0x6C2C2C), new MobSpawnSettings.Builder(), BiomeMaker.fireSwampGen()).m_47597_(Biome.Precipitation.NONE).m_47609_(1.0f).m_47611_(0.4f).m_47592_());
    }

    private static void darkForestBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.DARK_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().m_48040_(0).m_48019_(0).m_48045_(4941652).m_48043_(3890751).m_48031_(BiomeGrassColors.DARK_FOREST), BiomeMaker.darkForestSpawning(), BiomeMaker.darkForestGen()).m_47609_(0.7f).m_47611_(0.8f).m_47592_());
        biomes.put(BiomeKeys.DARK_FOREST_CENTER, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().m_48040_(0).m_48019_(4796416).m_48045_(6714688).m_48043_(16351774).m_48031_(BiomeGrassColors.DARK_FOREST_CENTER), new MobSpawnSettings.Builder(), BiomeMaker.darkForestCenterGen()).m_47592_());
    }

    private static void snowRegionBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.SNOWY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().m_48040_(0x808080).m_48019_(0xFFFFFF).m_48043_(0xFFFFFF).m_48045_(0xFFFFFF), BiomeMaker.snowForestSpawning(), BiomeMaker.snowyForestGen()).m_47597_(Biome.Precipitation.SNOW).m_47609_(0.09f).m_47611_(0.9f).m_47592_());
        biomes.put(BiomeKeys.GLACIER, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().m_48040_(1248552).m_48019_(3547016), BiomeMaker.penguinSpawning(), BiomeMaker.glacierGen()).m_47609_(0.8f).m_47611_(0.1f).m_47597_(Biome.Precipitation.SNOW).m_47592_());
    }

    private static void highlandsBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.HIGHLANDS, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.highlandsGen()).m_47609_(0.4f).m_47611_(0.7f).m_47592_());
        biomes.put(BiomeKeys.THORNLANDS, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), new MobSpawnSettings.Builder(), BiomeMaker.thornlandsGen()).m_47609_(0.3f).m_47611_(0.2f).m_47592_());
        biomes.put(BiomeKeys.FINAL_PLATEAU, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.ravenSpawning(), BiomeMaker.plateauGen()).m_47609_(1.0f).m_47611_(0.2f).m_47592_());
    }
}

