/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.phys.Vec2;
import org.lwjgl.opengl.GL11;

public class GhostIngredientDrag<T> {
    private static final int targetColor = 1075038474;
    private static final int hoverColor = -2142451431;
    private final IGhostIngredientHandler<?> handler;
    private final List<IGhostIngredientHandler.Target<T>> targets;
    private final List<Rect2i> targetAreas;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final ITypedIngredient<T> ingredient;
    private final double mouseStartX;
    private final double mouseStartY;
    private final ImmutableRect2i origin;

    public GhostIngredientDrag(IGhostIngredientHandler<?> handler, List<IGhostIngredientHandler.Target<T>> targets, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> ingredient, double mouseX, double mouseY, ImmutableRect2i origin) {
        this.handler = handler;
        this.targets = targets;
        this.targetAreas = targets.stream().map(IGhostIngredientHandler.Target::getArea).toList();
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.origin = origin;
        this.mouseStartX = mouseX;
        this.mouseStartY = mouseY;
    }

    public void drawTargets(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.handler.shouldHighlightTargets()) {
            GhostIngredientDrag.drawTargets(poseStack, mouseX, mouseY, this.targetAreas);
        }
    }

    public static boolean farEnoughToDraw(GhostIngredientDrag<?> drag, double mouseX, double mouseY) {
        ImmutableRect2i origin = drag.getOrigin();
        Vec2 center = origin.isEmpty() ? new Vec2((float)drag.mouseStartX, (float)drag.mouseStartY) : new Vec2((float)origin.getX() + (float)origin.getWidth() / 2.0f, (float)origin.getY() + (float)origin.getHeight() / 2.0f);
        double mouseXDist = (double)center.f_82470_ - mouseX;
        double mouseYDist = (double)center.f_82471_ - mouseY;
        double mouseDistSq = mouseXDist * mouseXDist + mouseYDist * mouseYDist;
        return mouseDistSq > 64.0;
    }

    public void drawItem(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (!GhostIngredientDrag.farEnoughToDraw(this, mouseX, mouseY)) {
            return;
        }
        if (!this.origin.isEmpty()) {
            int originX = this.origin.getX() + this.origin.getWidth() / 2;
            int originY = this.origin.getY() + this.origin.getHeight() / 2;
            RenderSystem.m_69472_();
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)false);
            ShaderInstance oldShader = RenderSystem.m_157196_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
            Tesselator tesselator = RenderSystem.m_69883_();
            BufferBuilder builder = tesselator.m_85915_();
            builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            float red = 0.2509804f;
            float green = 0.07450981f;
            float blue = 0.7882353f;
            float alpha = 0.039215688f;
            builder.m_5483_((double)mouseX, (double)mouseY, 150.0).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_5483_((double)originX, (double)originY, 150.0).m_85950_(red, green, blue, alpha).m_5752_();
            tesselator.m_85914_();
            RenderSystem.m_157427_(() -> oldShader);
            RenderSystem.m_69482_();
            RenderSystem.m_69493_();
            RenderSystem.m_69458_((boolean)true);
        }
        ItemRenderer itemRenderer = minecraft.m_91291_();
        itemRenderer.f_115093_ += 150.0f;
        poseStack.m_85836_();
        poseStack.m_85837_((double)(mouseX - 8), (double)(mouseY - 8), 0.0);
        this.ingredientRenderer.render(poseStack, this.ingredient.getIngredient());
        poseStack.m_85849_();
        itemRenderer.f_115093_ -= 150.0f;
    }

    public static void drawTargets(PoseStack poseStack, int mouseX, int mouseY, List<Rect2i> targetAreas) {
        RenderSystem.m_69465_();
        for (Rect2i area : targetAreas) {
            int color = MathUtil.contains(area, mouseX, mouseY) ? -2142451431 : 1075038474;
            GuiComponent.m_93172_((PoseStack)poseStack, (int)area.m_110085_(), (int)area.m_110086_(), (int)(area.m_110085_() + area.m_110090_()), (int)(area.m_110086_() + area.m_110091_()), (int)color);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean onClick(UserInput input) {
        for (IGhostIngredientHandler.Target<T> target : this.targets) {
            Rect2i area = target.getArea();
            if (!MathUtil.contains(area, input.getMouseX(), input.getMouseY())) continue;
            if (!input.isSimulate()) {
                target.accept(this.ingredient.getIngredient());
                this.handler.onComplete();
            }
            return true;
        }
        if (!input.isSimulate()) {
            this.handler.onComplete();
        }
        return false;
    }

    public void stop() {
        this.handler.onComplete();
    }

    public IIngredientRenderer<T> getIngredientRenderer() {
        return this.ingredientRenderer;
    }

    public ITypedIngredient<T> getIngredient() {
        return this.ingredient;
    }

    public ImmutableRect2i getOrigin() {
        return this.origin;
    }
}

