/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.registries;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.client.renderers.entities.alien.AlienRenderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.alienzombie.AlienZombieRenderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.flag.FlagHeadRenderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.globe.GlobeBlockRenderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.lander.LanderRenderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.martianraptor.MartianRaptorRenderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.mogler.MoglerRenderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.pygro.PygroModel;
import net.mrscauthd.beyond_earth.client.renderers.entities.pygro.PygroRenderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.pygrobrute.PygroBruteRenderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.rockettier1.RocketTier1Renderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.rockettier2.RocketTier2Renderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.rockettier3.RocketTier3Renderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.rockettier4.RocketTier4Renderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.rover.RoverRenderer;
import net.mrscauthd.beyond_earth.client.renderers.entities.starcrawler.StarCrawlerRenderer;
import net.mrscauthd.beyond_earth.client.sounds.TickableBeepSound;
import net.mrscauthd.beyond_earth.client.sounds.TickableLandingSound;
import net.mrscauthd.beyond_earth.common.entities.LanderEntity;
import net.mrscauthd.beyond_earth.common.registries.BlockEntityRegistry;
import net.mrscauthd.beyond_earth.common.registries.EntityRegistry;

@Mod.EventBusSubscriber(modid="beyond_earth", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EntityRendererRegistry {
    @SubscribeEvent
    public static void register(EntityRenderersEvent.RegisterRenderers event) {
        LanderEntity.playBeep = e -> {
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91106_().m_120367_((SoundInstance)new TickableBeepSound((LanderEntity)((Object)e)));
        };
        LanderEntity.playBoost = e -> {
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91106_().m_120367_((SoundInstance)new TickableLandingSound((LanderEntity)((Object)e)));
        };
        event.registerEntityRenderer((EntityType)EntityRegistry.ALIEN.get(), AlienRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ALIEN_ZOMBIE.get(), AlienZombieRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.STAR_CRAWLER.get(), StarCrawlerRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.PYGRO.get(), p_174068_ -> new PygroRenderer(p_174068_, PygroModel.LAYER_LOCATION, ModelLayers.f_171158_, ModelLayers.f_171159_));
        event.registerEntityRenderer((EntityType)EntityRegistry.PYGRO_BRUTE.get(), p_174068_ -> new PygroBruteRenderer(p_174068_, PygroModel.LAYER_LOCATION, ModelLayers.f_171156_, ModelLayers.f_171157_));
        event.registerEntityRenderer((EntityType)EntityRegistry.MOGLER.get(), MoglerRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.MARTIAN_RAPTOR.get(), MartianRaptorRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ICE_SPIT_ENTITY.get(), renderManager -> new ThrownItemRenderer(renderManager, 1.0f, true));
        event.registerEntityRenderer((EntityType)EntityRegistry.TIER_1_ROCKET.get(), RocketTier1Renderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.TIER_2_ROCKET.get(), RocketTier2Renderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.TIER_3_ROCKET.get(), RocketTier3Renderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.TIER_4_ROCKET.get(), RocketTier4Renderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.LANDER.get(), LanderRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.ROVER.get(), RoverRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.FLAG_BLOCK_ENTITY.get(), FlagHeadRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.GLOBE_BLOCK_ENTITY.get(), GlobeBlockRenderer::new);
    }
}

