/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.renderers.sky;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.client.renderers.sky.helper.SkyHelper;
import net.mrscauthd.beyond_earth.client.renderers.sky.helper.StarHelper;
import net.mrscauthd.beyond_earth.common.util.Planets;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PlanetSky
extends DimensionSpecialEffects {
    private final VertexBuffer starBuffer = StarHelper.createStars(0.1f, 190, 160, -1);
    private final float[] sunriseCol = new float[4];
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];
    private Planets.Planet planet;

    public PlanetSky(float cloudLevel, Planets.Planet planet) {
        super(cloudLevel, false, DimensionSpecialEffects.SkyType.NONE, false, false);
        SkyHelper.setupRainSize(this.rainSizeX, this.rainSizeZ);
        this.planet = planet;
    }

    public Vec3 m_5927_(Vec3 colour, float brightness) {
        if (this.planet != null && this.planet.airDensity <= 0.0f) {
            return colour;
        }
        return colour.m_82542_((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f));
    }

    @Nullable
    public float[] m_7518_(float time, float partialTick) {
        if (this.planet == null) {
            return null;
        }
        if (this.planet.airDensity <= 0.0f || this.planet.sunriseColour[0] < 0.0f) {
            this.sunriseCol[0] = 0.0f;
            this.sunriseCol[1] = 0.0f;
            this.sunriseCol[2] = 0.0f;
            this.sunriseCol[3] = 0.0f;
            return this.sunriseCol;
        }
        float dr = this.planet.sunriseColour[0];
        float dg = this.planet.sunriseColour[1];
        float db = this.planet.sunriseColour[2];
        float f = 0.4f;
        float f1 = Mth.m_14089_((float)(time * ((float)Math.PI * 2))) - 0.0f;
        float f2 = -0.0f;
        if (f1 >= -f && f1 <= f) {
            float f3 = (f1 - f2) / f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - Mth.m_14031_((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.sunriseCol[0] = f3 * 0.3f + dr;
            this.sunriseCol[1] = f3 * f3 * 0.7f + dg;
            this.sunriseCol[2] = f3 * f3 * 0.0f + db;
            this.sunriseCol[3] = f4;
            return this.sunriseCol;
        }
        return null;
    }

    public boolean m_5781_(int p_108874_, int p_108875_) {
        return false;
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        if (this.planet == null) {
            return false;
        }
        return !this.planet.hasClouds;
    }

    public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
        if (this.planet == null) {
            return false;
        }
        return !this.planet.hasRain;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogtype;
        if (this.planet == null) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        setupFog.run();
        if (!isFoggy && (fogtype = camera.m_167685_()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !mc.f_91060_.m_234310_(camera)) {
            Vec3 vec3 = mc.f_91073_.m_171660_(mc.f_91063_.m_109153_().m_90583_(), partialTick);
            float r = (float)vec3.f_82479_;
            float g = (float)vec3.f_82480_;
            float b = (float)vec3.f_82481_;
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            ShaderInstance shaderInstance = RenderSystem.m_157196_();
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            float dayTime = level.m_46942_(partialTick);
            float worldTime = (float)level.m_46468_() + partialTick;
            float dayAngle = dayTime * 360.0f % 360.0f;
            float skyLight = 1.0f - 2.0f * Math.abs(dayTime - 0.5f);
            FogRenderer.m_109036_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
            SkyHelper.drawSky(mc, matrix4f, projectionMatrix, shaderInstance);
            SkyHelper.setupSunRiseColor(poseStack, bufferBuilder, partialTick, mc, true);
            float rainLevel = 1.0f - mc.f_91073_.m_46722_(partialTick);
            float starLight = mc.f_91073_.m_104811_(partialTick) * rainLevel;
            if (starLight > 0.0f) {
                matrix4f = SkyHelper.setMatrixRot(poseStack, (Triple<Quaternion, Quaternion, Quaternion>)Triple.of((Object)Vector3f.f_122225_.m_122240_(-90.0f), (Object)Vector3f.f_122223_.m_122240_(dayAngle), null));
                RenderSystem.m_157429_((float)starLight, (float)starLight, (float)starLight, (float)starLight);
                SkyHelper.drawStars(this.starBuffer, matrix4f, projectionMatrix, GameRenderer.m_172811_(), setupFog, true);
            }
            this.planet = Planets.getLocationForPlanet((Level)level);
            SkyHelper.drawPlanetsAndParents(poseStack, bufferBuilder, camera, dayAngle, skyLight, worldTime, this.planet);
            SkyHelper.drawDarkSky(mc, poseStack, projectionMatrix, shaderInstance, partialTick);
            SkyHelper.setupShaderColor(mc, r, g, b);
            RenderSystem.m_69458_((boolean)true);
        }
        return true;
    }

    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
        if (this.planet == null) {
            return false;
        }
        if (this.planet.hasDustStorms) {
            Minecraft mc = Minecraft.m_91087_();
            float f = mc.f_91073_.m_46722_(partialTick);
            if (!(f <= 0.0f)) {
                lightTexture.m_109896_();
                int i = Mth.m_14107_((double)camX);
                int j = Mth.m_14107_((double)camY);
                int k = Mth.m_14107_((double)camZ);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                RenderSystem.m_69464_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_69482_();
                int l = 5;
                if (Minecraft.m_91405_()) {
                    l = 10;
                }
                RenderSystem.m_69458_((boolean)Minecraft.m_91085_());
                int i1 = -1;
                float f1 = (float)ticks + partialTick;
                RenderSystem.m_157427_(GameRenderer::m_172829_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int j1 = k - l; j1 <= k + l; ++j1) {
                    for (int k1 = i - l; k1 <= i + l; ++k1) {
                        int k4;
                        int j4;
                        int i4;
                        int l3;
                        int k3;
                        float f9;
                        float f8;
                        double d5;
                        double d3;
                        float f7;
                        float f6;
                        float f5;
                        int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                        double d0 = (double)this.rainSizeX[l1] * 0.5;
                        double d1 = (double)this.rainSizeZ[l1] * 0.5;
                        blockpos$mutableblockpos.m_122169_((double)k1, camY, (double)j1);
                        Biome biome = (Biome)level.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_();
                        if (biome.m_47530_() == Biome.Precipitation.NONE) continue;
                        int i2 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, k1, j1);
                        int j2 = j - l;
                        int k2 = j + l;
                        if (j2 < i2) {
                            j2 = i2;
                        }
                        if (k2 < i2) {
                            k2 = i2;
                        }
                        int l2 = i2;
                        if (i2 < j) {
                            l2 = j;
                        }
                        if (j2 == k2) continue;
                        RandomSource randomsource = RandomSource.m_216335_((long)((long)k1 * (long)k1 * 3121L + (long)k1 * 45238971L ^ (long)j1 * (long)j1 * 418711L + (long)j1 * 13761L));
                        blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                        if (biome.m_198906_((BlockPos)blockpos$mutableblockpos)) {
                            if (i1 != 0) {
                                if (i1 >= 0) {
                                    tesselator.m_85914_();
                                }
                                i1 = 0;
                                RenderSystem.m_157456_((int)0, (ResourceLocation)SkyHelper.MARS_DUST);
                                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                            }
                            f5 = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
                            f6 = (float)(randomsource.m_188500_() + (double)f1 * 0.08 * (double)((float)randomsource.m_188583_()));
                            f7 = (float)(randomsource.m_188500_() + (double)(f1 * (float)randomsource.m_188583_()) * 0.008);
                            d3 = (double)k1 + 0.5 - camX;
                            d5 = (double)j1 + 0.5 - camZ;
                            f8 = (float)Math.sqrt(d3 * d3 + d5 * d5) / (float)l;
                            f9 = ((1.0f - f8 * f8) * 0.3f + 0.5f) * f;
                            blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                            k3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                            l3 = k3 >> 16 & 0xFFFF;
                            i4 = k3 & 0xFFFF;
                            j4 = (l3 * 3 + 240) / 4;
                            k4 = (i4 * 3 + 240) / 4;
                            bufferbuilder.m_5483_((double)k1 - camX - d0 + 0.5, (double)k2 - camY, (double)j1 - camZ - d1 + 0.5).m_7421_(0.0f + f6, (float)j2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                            bufferbuilder.m_5483_((double)k1 - camX + d0 + 0.5, (double)k2 - camY, (double)j1 - camZ + d1 + 0.5).m_7421_(1.0f + f6, (float)j2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                            bufferbuilder.m_5483_((double)k1 - camX + d0 + 0.5, (double)j2 - camY, (double)j1 - camZ + d1 + 0.5).m_7421_(1.0f + f6, (float)k2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                            bufferbuilder.m_5483_((double)k1 - camX - d0 + 0.5, (double)j2 - camY, (double)j1 - camZ - d1 + 0.5).m_7421_(0.0f + f6, (float)k2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                            continue;
                        }
                        if (i1 != 1) {
                            if (i1 >= 0) {
                                tesselator.m_85914_();
                            }
                            i1 = 1;
                            RenderSystem.m_157456_((int)0, (ResourceLocation)SkyHelper.SNOW);
                            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        f5 = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
                        f6 = (float)(randomsource.m_188500_() + (double)f1 * 0.01 * (double)((float)randomsource.m_188583_()));
                        f7 = (float)(randomsource.m_188500_() + (double)(f1 * (float)randomsource.m_188583_()) * 0.001);
                        d3 = (double)k1 + 0.5 - camX;
                        d5 = (double)j1 + 0.5 - camZ;
                        f8 = (float)Math.sqrt(d3 * d3 + d5 * d5) / (float)l;
                        f9 = ((1.0f - f8 * f8) * 0.3f + 0.5f) * f;
                        blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                        k3 = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        l3 = k3 >> 16 & 0xFFFF;
                        i4 = k3 & 0xFFFF;
                        j4 = (l3 * 3 + 240) / 4;
                        k4 = (i4 * 3 + 240) / 4;
                        bufferbuilder.m_5483_((double)k1 - camX - d0 + 0.5, (double)k2 - camY, (double)j1 - camZ - d1 + 0.5).m_7421_(0.0f + f6, (float)j2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - camX + d0 + 0.5, (double)k2 - camY, (double)j1 - camZ + d1 + 0.5).m_7421_(1.0f + f6, (float)j2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - camX + d0 + 0.5, (double)j2 - camY, (double)j1 - camZ + d1 + 0.5).m_7421_(1.0f + f6, (float)k2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                        bufferbuilder.m_5483_((double)k1 - camX - d0 + 0.5, (double)j2 - camY, (double)j1 - camZ - d1 + 0.5).m_7421_(0.0f + f6, (float)k2 * 0.25f + f5 + f7).m_85950_(1.0f, 1.0f, 1.0f, f9).m_7120_(k4, j4).m_5752_();
                    }
                }
                if (i1 >= 0) {
                    tesselator.m_85914_();
                }
                RenderSystem.m_69481_();
                RenderSystem.m_69461_();
                lightTexture.m_109891_();
            }
            return true;
        }
        return !this.planet.hasRain;
    }
}

