/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.renderers.sky.helper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import net.mrscauthd.beyond_earth.common.util.Planets;
import org.apache.commons.lang3.tuple.Triple;

public class SkyHelper {
    public static final ResourceLocation WHITE_SUN = new ResourceLocation("beyond_earth", "textures/environment/planet/white_sun.png");
    public static final ResourceLocation SUN = new ResourceLocation("beyond_earth", "textures/environment/planet/sun.png");
    public static final ResourceLocation MOON_PHASE = new ResourceLocation("beyond_earth", "textures/environment/planet/moon_phases.png");
    public static final ResourceLocation EARTH = new ResourceLocation("beyond_earth", "textures/environment/planet/earth.png");
    public static final ResourceLocation MARS = new ResourceLocation("beyond_earth", "textures/environment/planet/mars.png");
    public static final ResourceLocation PHOBOS = new ResourceLocation("beyond_earth", "textures/environment/planet/phobos.png");
    public static final ResourceLocation DEIMOS = new ResourceLocation("beyond_earth", "textures/environment/planet/deimos.png");
    public static final ResourceLocation PLANET_LIGHT = new ResourceLocation("beyond_earth", "textures/environment/planet/planet_light.png");
    public static final ResourceLocation PLANET_PHASE_LIGHT = new ResourceLocation("beyond_earth", "textures/environment/planet/planet_phases_light.png");
    public static final ResourceLocation MARS_DUST = new ResourceLocation("beyond_earth", "textures/environment/mars_dust.png");
    public static final ResourceLocation SNOW = new ResourceLocation("textures/environment/snow.png");
    private static int alpha = 255;

    public static void drawStars(VertexBuffer vertexBuffer, Matrix4f matrix4f, Matrix4f projectionMatrix, ShaderInstance shaderInstance, Runnable setupFog, boolean blend) {
        if (blend) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        FogRenderer.m_109017_();
        vertexBuffer.m_85921_();
        vertexBuffer.m_166867_(matrix4f, projectionMatrix, shaderInstance);
        VertexBuffer.m_85931_();
        setupFog.run();
        if (blend) {
            RenderSystem.m_69461_();
        }
    }

    public static void drawPlanetWithMoonPhaseAndWithLight(ResourceLocation texture, Vec3 lightColor, BufferBuilder bufferBuilder, Matrix4f matrix4f, float size, float lightSize, float y, Minecraft mc, boolean blend) {
        SkyHelper.drawPlanetWithMoonPhaseAndWithLight(texture, lightColor, bufferBuilder, matrix4f, size, lightSize, y, mc, blend, mc.f_91073_.m_46941_());
    }

    public static void drawPlanetWithMoonPhaseAndWithLight(ResourceLocation texture, Vec3 lightColor, BufferBuilder bufferBuilder, Matrix4f matrix4f, float size, float lightSize, float y, Minecraft mc, boolean blend, int phase) {
        SkyHelper.drawPlanetWithMoonPhase(texture, new Vec3(255.0, 255.0, 255.0), bufferBuilder, matrix4f, size, y, mc, blend, phase);
        SkyHelper.drawPlanetWithMoonPhase(PLANET_PHASE_LIGHT, lightColor, bufferBuilder, matrix4f, lightSize, y, mc, true, phase);
    }

    public static void drawPlanetWithMoonPhase(ResourceLocation texture, Vec3 color, BufferBuilder bufferBuilder, Matrix4f matrix4f, float size, float y, Minecraft mc, boolean blend, int phase) {
        if (blend) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        int r = (int)color.m_7096_();
        int g = (int)color.m_7098_();
        int b = (int)color.m_7094_();
        RenderSystem.m_69493_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        int l = phase % 4;
        int i1 = phase / 4 % 2;
        float f13 = (float)l / 4.0f;
        float f14 = (float)i1 / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferBuilder.m_85982_(matrix4f, -size, -y, size).m_6122_(r, g, b, 255).m_7421_(f15, f16).m_5752_();
        bufferBuilder.m_85982_(matrix4f, size, -y, size).m_6122_(r, g, b, 255).m_7421_(f13, f16).m_5752_();
        bufferBuilder.m_85982_(matrix4f, size, -y, -size).m_6122_(r, g, b, 255).m_7421_(f13, f14).m_5752_();
        bufferBuilder.m_85982_(matrix4f, -size, -y, -size).m_6122_(r, g, b, 255).m_7421_(f15, f14).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69472_();
        if (blend) {
            RenderSystem.m_69461_();
        }
    }

    public static void drawSunWithLight(ResourceLocation texture, Vec3 sunColor, Vec3 lightColor, BufferBuilder bufferBuilder, Matrix4f matrix4f, float size, float lightSize, float y, boolean blend) {
        SkyHelper.drawPlanet(texture, sunColor, bufferBuilder, matrix4f, size, y, blend);
        SkyHelper.drawPlanet(PLANET_LIGHT, lightColor, bufferBuilder, matrix4f, lightSize, y, true);
    }

    public static void drawPlanetWithLight(ResourceLocation texture, Vec3 lightColor, BufferBuilder bufferBuilder, Matrix4f matrix4f, float size, float lightSize, float y, boolean blend) {
        SkyHelper.drawPlanet(texture, new Vec3(255.0, 255.0, 255.0), bufferBuilder, matrix4f, size, y, blend);
        SkyHelper.drawPlanet(PLANET_LIGHT, lightColor, bufferBuilder, matrix4f, lightSize, y, true);
    }

    public static void drawPlanet(ResourceLocation texture, Vec3 color, BufferBuilder bufferBuilder, Matrix4f matrix4f, float size, float y, boolean blend) {
        if (blend) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        int r = (int)color.m_7096_();
        int g = (int)color.m_7098_();
        int b = (int)color.m_7094_();
        int a = alpha;
        RenderSystem.m_69493_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferBuilder.m_85982_(matrix4f, -size, y, -size).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, size, y, -size).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, size, y, size).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, -size, y, size).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69472_();
        if (blend) {
            RenderSystem.m_69461_();
        }
    }

    public static void drawParentsPlanetsBeforeParent(PoseStack poseStack, BufferBuilder bufferBuilder, float dayAngle, float skyLight, Planets.CelestialBody parent, Planets.Planet planet, Object2ObjectArrayMap<Planets.Planet, float[]> renderLater) {
        if (parent == null) {
            return;
        }
        boolean inner = true;
        for (Planets.Planet p : planet._parent.children) {
            boolean render;
            if (p == planet) {
                inner = false;
                continue;
            }
            float distance = (float)(inner ? planet.orbitRadius / p.orbitRadius : p.orbitRadius / planet.orbitRadius);
            float phase = p.orbitPhase - planet.orbitPhase;
            float dAngle = 90.0f * Mth.m_14031_((float)phase) / distance;
            float angle = dayAngle + (inner ? dAngle : phase);
            float lighting = 3.0f * dAngle * skyLight / 90.0f;
            boolean bl = render = !inner || phase < 180.0f;
            if (render) {
                float inclination = (float)(10.0 * Math.sin(Math.toRadians(phase)));
                Matrix4f matrix4f = SkyHelper.setMatrixRot(poseStack, (Triple<Quaternion, Quaternion, Quaternion>)Triple.of((Object)Vector3f.f_122225_.m_122240_(-90.0f), (Object)Vector3f.f_122223_.m_122240_(angle), (Object)Vector3f.f_122227_.m_122240_(inclination)));
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                alpha = (int)(255.0f * skyLight);
                SkyHelper.drawPlanetWithLight(p.texture, p.getLightColour(), bufferBuilder, matrix4f, 3.0f, lighting, 100.0f * distance, true);
                alpha = 255;
                continue;
            }
            renderLater.put((Object)p, (Object)new float[]{distance, angle, dAngle});
        }
        if (parent instanceof Planets.Planet) {
            Planets.Planet parent2 = (Planets.Planet)parent;
            SkyHelper.drawParentsPlanetsBeforeParent(poseStack, bufferBuilder, dayAngle, skyLight, parent2._parent, parent2, renderLater);
        }
    }

    public static void drawPlanetsAndParents(PoseStack poseStack, BufferBuilder bufferBuilder, Camera camera, float dayAngle, float skyLight, float worldTime, Planets.Planet planet) {
        SkyHelper.drawPlanetsAndParents(poseStack, bufferBuilder, camera, dayAngle, skyLight, worldTime, planet, 1, true);
    }

    public static void drawPlanetsAndParents(PoseStack poseStack, BufferBuilder bufferBuilder, Camera camera, float dayAngle, float skyLight, float worldTime, Planets.Planet planet, int parentDepth, boolean includeMoons) {
        if (planet != null) {
            Object2ObjectArrayMap renderAfterSun = new Object2ObjectArrayMap();
            Planets.CelestialBody parent = planet._parent;
            if (parent != null && parent instanceof Planets.Planet) {
                Planets.Planet planet2 = (Planets.Planet)parent;
                SkyHelper.drawPlanetsAndParents(poseStack, bufferBuilder, camera, dayAngle, skyLight, worldTime, planet2, parentDepth + 1, false);
            }
            SkyHelper.drawParentsPlanetsBeforeParent(poseStack, bufferBuilder, dayAngle, skyLight, planet._parent, planet, (Object2ObjectArrayMap<Planets.Planet, float[]>)renderAfterSun);
            float scale = (float)(10.0 * planet.orbitRadius / 1.49598016E8);
            if (parent instanceof Planets.Planet) {
                scale = (float)(0.15 * Math.sqrt(parent.radius * 384399.0 / planet.orbitRadius));
            }
            float angle = dayAngle;
            if (planet.tidalLock) {
                Vec3 cameraPos = camera.m_90583_();
                double y = 50.0 * cameraPos.m_7096_() / planet.radius;
                angle = (float)(-30.0 + y) % 360.0f;
            }
            if (parent instanceof Planets.Planet) {
                angle += (float)(parentDepth * 10);
            }
            ResourceLocation texture = planet._parent.texture != null ? planet._parent.texture : WHITE_SUN;
            Matrix4f matrix4f = SkyHelper.setMatrixRot(poseStack, (Triple<Quaternion, Quaternion, Quaternion>)Triple.of((Object)Vector3f.f_122225_.m_122240_(-90.0f), (Object)Vector3f.f_122223_.m_122240_(angle), null));
            Vec3 colour = parent.getLightColour();
            if (!(parent instanceof Planets.Planet)) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                SkyHelper.drawSunWithLight(texture, colour, colour, bufferBuilder, matrix4f, scale, 20.0f, 100.0f, true);
                SkyHelper.drawParentsPlanetsAfterParent(poseStack, bufferBuilder, dayAngle, skyLight, planet._parent, planet, (Object2ObjectArrayMap<Planets.Planet, float[]>)renderAfterSun);
            } else {
                float lighting = 3.0f * skyLight / 90.0f;
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                SkyHelper.drawParentsPlanetsAfterParent(poseStack, bufferBuilder, dayAngle, skyLight, planet._parent, planet, (Object2ObjectArrayMap<Planets.Planet, float[]>)renderAfterSun);
                SkyHelper.drawPlanetWithLight(texture, colour, bufferBuilder, matrix4f, scale, lighting, 100.0f, false);
            }
            if (includeMoons) {
                SkyHelper.drawSatellitesForPlanet(poseStack, bufferBuilder, dayAngle, skyLight, worldTime, planet);
            }
        }
    }

    public static void drawParentsPlanetsAfterParent(PoseStack poseStack, BufferBuilder bufferBuilder, float dayAngle, float skyLight, Planets.CelestialBody parent, Planets.Planet planet, Object2ObjectArrayMap<Planets.Planet, float[]> renderLater) {
        for (Map.Entry pair : renderLater.entrySet()) {
            Planets.Planet p = (Planets.Planet)pair.getKey();
            float[] params = (float[])pair.getValue();
            float distance = params[0];
            float angle = params[1];
            float inclination = (float)(10.0 * Math.sin(p.orbitPhase));
            Matrix4f matrix4f = SkyHelper.setMatrixRot(poseStack, (Triple<Quaternion, Quaternion, Quaternion>)Triple.of((Object)Vector3f.f_122225_.m_122240_(-90.0f), (Object)Vector3f.f_122223_.m_122240_(angle), (Object)Vector3f.f_122227_.m_122240_(inclination)));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            alpha = (int)(255.0f * skyLight);
            SkyHelper.drawPlanetWithLight(p.texture, p.getLightColour(), bufferBuilder, matrix4f, 3.0f, 12.0f, 100.0f * distance, true);
            alpha = 255;
        }
    }

    public static void drawSatellitesForPlanet(PoseStack poseStack, BufferBuilder bufferBuilder, float dayAngle, float skyLight, float worldTime, Planets.CelestialBody parent) {
        for (Planets.Planet p : parent.children) {
            p.orbitPhase = Planets.getRotation(p, worldTime, 1.0f);
            float moonSize = (float)(3500.0 * p.radius / p.orbitRadius);
            float phase = dayAngle + p.orbitPhase;
            alpha = (int)(255.0f * skyLight);
            float inclination = (float)(10.0 * Math.sin(Math.toRadians(phase)));
            Matrix4f matrix4f = SkyHelper.setMatrixRot(poseStack, (Triple<Quaternion, Quaternion, Quaternion>)Triple.of((Object)Vector3f.f_122225_.m_122240_(-90.0f), (Object)Vector3f.f_122223_.m_122240_(phase), (Object)Vector3f.f_122227_.m_122240_(inclination)));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (p.phaseTexture != null) {
                int moonPhase = (int)(45.0f + (phase -= dayAngle) % 360.0f) / 45;
                Minecraft mc = Minecraft.m_91087_();
                SkyHelper.drawPlanetWithMoonPhaseAndWithLight(p.phaseTexture, p.getLightColour(), bufferBuilder, matrix4f, moonSize *= 2.0f, moonSize, 100.0f, mc, false, moonPhase);
            } else {
                SkyHelper.drawPlanetWithLight(p.texture, p.getLightColour(), bufferBuilder, matrix4f, moonSize, moonSize, 100.0f, false);
            }
            alpha = 255;
        }
    }

    public static void drawSunWithLightAndSatellites(Minecraft mc, ResourceLocation texture, Vec3 color, Vec3 lightColor, Vec3 satelliteColor, BufferBuilder bufferBuilder, Matrix4f matrix4f, float size, float lightSize, float satelliteSize, int satellites, float satelliteSpeed, float xAngle, float yAngle, float zAngle, float y, boolean blend, boolean satelliteBlend) {
        SkyHelper.drawPlanetWithSatellites(mc, texture, color, satelliteColor, bufferBuilder, matrix4f, size, satelliteSize, satellites, satelliteSpeed, xAngle, yAngle, zAngle, y, blend, satelliteBlend);
        SkyHelper.drawPlanet(PLANET_LIGHT, lightColor, bufferBuilder, matrix4f, lightSize, y, true);
    }

    public static void drawPlanetWithLightAndSatellites(Minecraft mc, ResourceLocation texture, Vec3 lightColor, Vec3 satelliteColor, BufferBuilder bufferBuilder, Matrix4f matrix4f, float size, float lightSize, float satelliteSize, int satellites, float satelliteSpeed, float xAngle, float yAngle, float zAngle, float y, boolean blend, boolean satelliteBlend) {
        SkyHelper.drawPlanetWithSatellites(mc, texture, new Vec3(255.0, 255.0, 255.0), satelliteColor, bufferBuilder, matrix4f, size, satelliteSize, satellites, satelliteSpeed, xAngle, yAngle, zAngle, y, blend, satelliteBlend);
        SkyHelper.drawPlanet(PLANET_LIGHT, lightColor, bufferBuilder, matrix4f, lightSize, y, true);
    }

    public static void drawPlanetWithSatellites(Minecraft mc, ResourceLocation texture, Vec3 color, Vec3 satelliteColor, BufferBuilder bufferBuilder, Matrix4f matrix4f, float size, float satelliteSize, int satellites, float satelliteSpeed, float xAngle, float yAngle, float zAngle, float y, boolean blend, boolean satelliteBlend) {
        float yPos;
        float cosTick;
        float sinTick;
        int i;
        float gameTick = ((float)mc.f_91073_.m_46467_() + mc.getPartialTick()) / satelliteSpeed;
        float distance = 6.3f / (float)satellites;
        for (i = 0; i < satellites; ++i) {
            sinTick = (float)Math.sin(gameTick + distance * (float)i);
            cosTick = (float)Math.cos(gameTick + distance * (float)i);
            yPos = y + cosTick * yAngle;
            if (!(y < yPos)) continue;
            SkyHelper.drawSatellites(satelliteColor, bufferBuilder, matrix4f, sinTick, cosTick, xAngle, yAngle, zAngle, satelliteSize, y, satelliteBlend);
        }
        SkyHelper.drawPlanet(texture, color, bufferBuilder, matrix4f, size, y, blend);
        for (i = 0; i < satellites; ++i) {
            sinTick = (float)Math.sin(gameTick + distance * (float)i);
            cosTick = (float)Math.cos(gameTick + distance * (float)i);
            yPos = y + cosTick * yAngle;
            if (!(y > yPos)) continue;
            SkyHelper.drawSatellites(satelliteColor, bufferBuilder, matrix4f, sinTick, cosTick, xAngle, yAngle, zAngle, satelliteSize, y, satelliteBlend);
        }
    }

    public static void drawSatellites(Vec3 color, BufferBuilder bufferBuilder, Matrix4f matrix4f, float sinTick, float cosTick, float xAngle, float yAngle, float zAngle, float size, float y, boolean blend) {
        if (blend) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        int r = (int)color.m_7096_();
        int g = (int)color.m_7098_();
        int b = (int)color.m_7094_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_85982_(matrix4f, sinTick * xAngle - size, y + cosTick * yAngle, cosTick * zAngle - size).m_6122_(r, g, b, 255).m_5752_();
        bufferBuilder.m_85982_(matrix4f, sinTick * xAngle + size, y + cosTick * yAngle, cosTick * zAngle - size).m_6122_(r, g, b, 255).m_5752_();
        bufferBuilder.m_85982_(matrix4f, sinTick * xAngle + size, y + cosTick * yAngle, cosTick * zAngle + size).m_6122_(r, g, b, 255).m_5752_();
        bufferBuilder.m_85982_(matrix4f, sinTick * xAngle - size, y + cosTick * yAngle, cosTick * zAngle + size).m_6122_(r, g, b, 255).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        if (blend) {
            RenderSystem.m_69461_();
        }
    }

    public static void setupSunRiseColor(PoseStack poseStack, BufferBuilder bufferBuilder, float partialTick, Minecraft mc, boolean blend) {
        float[] afloat;
        if (blend) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
        }
        if ((afloat = mc.f_91073_.m_104583_().m_7518_(mc.f_91073_.m_46942_(partialTick), partialTick)) != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69472_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            float f3 = Mth.m_14031_((float)mc.f_91073_.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f3));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_85982_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3]).m_5752_();
            int i = 16;
            for (int j = 0; j <= i; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = Mth.m_14031_((float)f7);
                float f9 = Mth.m_14089_((float)f7);
                bufferBuilder.m_85982_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            poseStack.m_85849_();
        }
        if (blend) {
            RenderSystem.m_69461_();
        }
    }

    public static void setupShaderColor(Minecraft mc, float r, float g, float b) {
        if (mc.f_91073_.m_104583_().m_108882_()) {
            RenderSystem.m_157429_((float)(r * 0.2f + 0.04f), (float)(g * 0.2f + 0.04f), (float)(b * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        }
    }

    public static void drawSky(Minecraft mc, Matrix4f matrix4f, Matrix4f projectionMatrix, ShaderInstance shaderInstance) {
        mc.f_91060_.f_109472_.m_85921_();
        mc.f_91060_.f_109472_.m_166867_(matrix4f, projectionMatrix, shaderInstance);
        VertexBuffer.m_85931_();
    }

    public static void drawDarkSky(Minecraft mc, PoseStack poseStack, Matrix4f projectionMatrix, ShaderInstance shaderInstance, float partialTick) {
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d0 = mc.f_91074_.m_20299_((float)partialTick).f_82480_ - mc.f_91073_.m_6106_().m_171687_((LevelHeightAccessor)mc.f_91073_);
        if (d0 < 0.0) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 12.0, 0.0);
            mc.f_91060_.f_109473_.m_85921_();
            mc.f_91060_.f_109473_.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, shaderInstance);
            VertexBuffer.m_85931_();
            poseStack.m_85849_();
        }
    }

    public static void setupRainSize(float[] rainSizeX, float[] rainSizeZ) {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f9 = j - 16;
                float f1 = i - 16;
                float f2 = Mth.m_14116_((float)(f9 * f9 + f1 * f1));
                rainSizeX[i << 5 | j] = -f1 / f2;
                rainSizeZ[i << 5 | j] = f9 / f2;
            }
        }
    }

    public static Matrix4f setMatrixRot(PoseStack poseStack, Triple<Quaternion, Quaternion, Quaternion> quaternionTriple) {
        poseStack.m_85836_();
        Quaternion left = (Quaternion)quaternionTriple.getLeft();
        Quaternion middle = (Quaternion)quaternionTriple.getMiddle();
        Quaternion right = (Quaternion)quaternionTriple.getRight();
        if (left != null) {
            poseStack.m_85845_((Quaternion)quaternionTriple.getLeft());
        }
        if (middle != null) {
            poseStack.m_85845_((Quaternion)quaternionTriple.getMiddle());
        }
        if (right != null) {
            poseStack.m_85845_((Quaternion)quaternionTriple.getRight());
        }
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        poseStack.m_85849_();
        return matrix4f;
    }
}

