/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;
import net.mrscauthd.beyond_earth.client.util.GuiHelper;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.OxygenDistributorBlockEntity;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.common.config.Config;
import net.mrscauthd.beyond_earth.common.menus.OxygenBubbleDistributorMenu;
import net.mrscauthd.beyond_earth.common.util.Rectangle2d;

@OnlyIn(value=Dist.CLIENT)
public class OxygenDistributorScreen
extends AbstractContainerScreen<OxygenBubbleDistributorMenu.GuiContainer> {
    public static final ResourceLocation texture = new ResourceLocation("beyond_earth", "textures/gui/oxygen_distributor.png");
    public static final int INPUT_TANK_LEFT = 51;
    public static final int INPUT_TANK_TOP = 58;
    public static final int OUTPUT_TANK_LEFT = 115;
    public static final int OUTPUT_TANK_TOP = 58;
    public static final int ENERGY_LEFT = 147;
    public static final int ENERGY_TOP = 58;
    public static final int ARROW_LEFT = 48;
    public static final int ARROW_TOP = 36;

    public OxygenDistributorScreen(OxygenBubbleDistributorMenu.GuiContainer container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.f_97726_ = 177;
        this.f_97727_ = 220;
        this.f_97731_ = this.f_97727_ - 92;
        this.f_97729_ += 34;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
        OxygenDistributorBlockEntity blockEntity = ((OxygenBubbleDistributorMenu.GuiContainer)this.m_6262_()).getBlockEntity();
        if (GuiHelper.isHover(this.getInputTankBounds(), mouseX, mouseY)) {
            this.m_96602_(ms, (Component)GaugeTextHelper.getStorageText(GaugeValueHelper.getFluid((IFluidTank)blockEntity.getInputTank())).build(), mouseX, mouseY);
        } else if (GuiHelper.isHover(this.getOutputTankBounds(), mouseX, mouseY)) {
            this.m_96602_(ms, (Component)GaugeTextHelper.getStorageText(GaugeValueHelper.getOxygen(blockEntity.getOutputTank())).build(), mouseX, mouseY);
        } else if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
            this.m_96602_(ms, (Component)GaugeTextHelper.getStorageText(GaugeValueHelper.getEnergy(blockEntity)).build(), mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack ms, float p_97788_, int p_97789_, int p_97790_) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)ms, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.f_97726_, (int)this.f_97727_);
        OxygenDistributorBlockEntity blockEntity = ((OxygenBubbleDistributorMenu.GuiContainer)this.m_6262_()).getBlockEntity();
        GuiHelper.drawEnergy(ms, this.f_97735_ + 147, this.f_97736_ + 58, blockEntity.getPrimaryEnergyStorage());
        GuiHelper.drawFluidTank(ms, this.f_97735_ + 51, this.f_97736_ + 58, (IFluidTank)blockEntity.getInputTank());
        GuiHelper.drawOxygenTank(ms, this.f_97735_ + 115, this.f_97736_ + 58, blockEntity.getOutputTank());
    }

    protected void m_7027_(PoseStack ms, int mouseX, int mouseY) {
        super.m_7027_(ms, mouseX, mouseY);
        OxygenDistributorBlockEntity blockEntity = ((OxygenBubbleDistributorMenu.GuiContainer)this.m_6262_()).getBlockEntity();
        ms.m_85836_();
        float oyxgenScale = 0.8f;
        ms.m_85841_(oyxgenScale, oyxgenScale, oyxgenScale);
        MutableComponent oxygenText = GaugeTextHelper.getUsingText2(GaugeValueHelper.getOxygen((Integer)Config.OXYGEN_BUBBLE_DISTRIBUTOR_RATE_OUTPUT.get()), blockEntity.getMaxTimer()).build();
        int oxygenWidth = this.f_96547_.m_92852_((FormattedText)oxygenText);
        this.f_96547_.m_92889_(ms, (Component)oxygenText, (float)((int)((float)(this.f_97726_ - 5) / oyxgenScale) - oxygenWidth), (float)((int)((float)this.f_97731_ / oyxgenScale)), 0x333333);
        ms.m_85849_();
    }

    public Rectangle2d getInputTankBounds() {
        return GuiHelper.getFluidTankBounds(this.f_97735_ + 51, this.f_97736_ + 58);
    }

    public Rectangle2d getOutputTankBounds() {
        return GuiHelper.getFluidTankBounds(this.f_97735_ + 115, this.f_97736_ + 58);
    }

    public Rectangle2d getEnergyBounds() {
        return GuiHelper.getEnergyBounds(this.f_97735_ + 147, this.f_97736_ + 58);
    }
}

