/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.screens.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class ScreenHelper {
    public static void drawVertical(PoseStack poseStack, int leftPos, int topPos, int width, int height, double min, double max, ResourceLocation resourceLocation, boolean blend) {
        double ratio = min / max;
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        if (blend) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)leftPos, (int)(topPos + remainHeight), (float)0.0f, (float)remainHeight, (int)width, (int)ratioHeight, (int)width, (int)height);
        if (blend) {
            RenderSystem.m_69461_();
        }
    }

    public static void drawHorizontal(PoseStack poseStack, int leftPos, int topPos, int width, int height, double min, double max, ResourceLocation resourceLocation, boolean blend) {
        double ratio = min / max;
        int ratioWidth = (int)Math.ceil((double)width * ratio);
        if (blend) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)leftPos, (int)topPos, (float)0.0f, (float)0.0f, (int)ratioWidth, (int)height, (int)width, (int)height);
        if (blend) {
            RenderSystem.m_69461_();
        }
    }

    public static void drawTexture(PoseStack poseStack, int leftPos, int topPos, int width, int height, ResourceLocation texture, boolean blend) {
        if (blend) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)leftPos, (int)topPos, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        if (blend) {
            RenderSystem.m_69461_();
        }
    }

    public static boolean isInArea(float mouseX, float mouseY, float x, float y, float width, float height) {
        return mouseX > x && mouseX < x + width && mouseY > y && mouseY < y + height;
    }

    public static class renderFluid {
        public static void drawFluidVertical(PoseStack poseStack, FluidStack fluidStack, int leftPos, int topPos, int width, int height, double maxAmount) {
            double ratio = (double)fluidStack.getAmount() / maxAmount;
            int ratioHeight = (int)Math.ceil((double)height * ratio);
            int remainHeight = height - ratioHeight;
            renderFluid.drawFluid(poseStack, fluidStack, leftPos, topPos, width, height, 0, -remainHeight);
        }

        public static void drawFluid(PoseStack poseStack, FluidStack fluidStack, int leftPos, int topPos, int width, int height, int xOffset, int yOffset) {
            if (fluidStack.getFluid() == null) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            TextureAtlasSprite sprite = (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(renderProperties.getStillTexture());
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
            GuiComponent.m_239260_((int)(leftPos - xOffset + 1), (int)(topPos - yOffset + 1), (int)(leftPos + width - 1), (int)(topPos + height - 1));
            int color = renderProperties.getTintColor();
            RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            for (int f1 = leftPos; f1 < leftPos + width; f1 += 16) {
                for (int f2 = topPos; f2 < topPos + height; f2 += 16) {
                    GuiComponent.m_93200_((PoseStack)poseStack, (int)f1, (int)f2, (int)0, (int)16, (int)16, (TextureAtlasSprite)sprite);
                }
            }
            RenderSystem.m_69471_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class renderTextureWithColor {
        public static void blit(PoseStack p_93201_, int p_93202_, int p_93203_, int p_93204_, int p_93205_, int p_93206_, TextureAtlasSprite p_93207_, Vec3 color) {
            renderTextureWithColor.innerBlit(p_93201_.m_85850_().m_85861_(), p_93202_, p_93202_ + p_93205_, p_93203_, p_93203_ + p_93206_, p_93204_, p_93207_.m_118409_(), p_93207_.m_118410_(), p_93207_.m_118411_(), p_93207_.m_118412_(), color);
        }

        public void blit(PoseStack p_93229_, int p_93230_, int p_93231_, int blitOffset, int p_93232_, int p_93233_, int p_93234_, int p_93235_, Vec3 color) {
            renderTextureWithColor.blit(p_93229_, p_93230_, p_93231_, blitOffset, p_93232_, p_93233_, p_93234_, p_93235_, 256, 256, color);
        }

        public static void blit(PoseStack p_93144_, int p_93145_, int p_93146_, int p_93147_, float p_93148_, float p_93149_, int p_93150_, int p_93151_, int p_93152_, int p_93153_, Vec3 color) {
            renderTextureWithColor.innerBlit(p_93144_, p_93145_, p_93145_ + p_93150_, p_93146_, p_93146_ + p_93151_, p_93147_, p_93150_, p_93151_, p_93148_, p_93149_, p_93152_, p_93153_, color);
        }

        public static void blit(PoseStack p_93161_, int p_93162_, int p_93163_, int p_93164_, int p_93165_, float p_93166_, float p_93167_, int p_93168_, int p_93169_, int p_93170_, int p_93171_, Vec3 color) {
            renderTextureWithColor.innerBlit(p_93161_, p_93162_, p_93162_ + p_93164_, p_93163_, p_93163_ + p_93165_, 0, p_93168_, p_93169_, p_93166_, p_93167_, p_93170_, p_93171_, color);
        }

        public static void blit(PoseStack p_93134_, int p_93135_, int p_93136_, float p_93137_, float p_93138_, int p_93139_, int p_93140_, int p_93141_, int p_93142_, Vec3 color) {
            renderTextureWithColor.blit(p_93134_, p_93135_, p_93136_, p_93139_, p_93140_, p_93137_, p_93138_, p_93139_, p_93140_, p_93141_, p_93142_, color);
        }

        private static void innerBlit(PoseStack p_93188_, int p_93189_, int p_93190_, int p_93191_, int p_93192_, int p_93193_, int p_93194_, int p_93195_, float p_93196_, float p_93197_, int p_93198_, int p_93199_, Vec3 color) {
            renderTextureWithColor.innerBlit(p_93188_.m_85850_().m_85861_(), p_93189_, p_93190_, p_93191_, p_93192_, p_93193_, (p_93196_ + 0.0f) / (float)p_93198_, (p_93196_ + (float)p_93194_) / (float)p_93198_, (p_93197_ + 0.0f) / (float)p_93199_, (p_93197_ + (float)p_93195_) / (float)p_93199_, color);
        }

        private static void innerBlit(Matrix4f p_93113_, int p_93114_, int p_93115_, int p_93116_, int p_93117_, int p_93118_, float p_93119_, float p_93120_, float p_93121_, float p_93122_, Vec3 color) {
            int r = (int)color.m_7096_();
            int g = (int)color.m_7098_();
            int b = (int)color.m_7094_();
            RenderSystem.m_157427_(GameRenderer::m_172814_);
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            bufferbuilder.m_85982_(p_93113_, (float)p_93114_, (float)p_93117_, (float)p_93118_).m_6122_(r, g, b, 255).m_7421_(p_93119_, p_93122_).m_5752_();
            bufferbuilder.m_85982_(p_93113_, (float)p_93115_, (float)p_93117_, (float)p_93118_).m_6122_(r, g, b, 255).m_7421_(p_93120_, p_93122_).m_5752_();
            bufferbuilder.m_85982_(p_93113_, (float)p_93115_, (float)p_93116_, (float)p_93118_).m_6122_(r, g, b, 255).m_7421_(p_93120_, p_93121_).m_5752_();
            bufferbuilder.m_85982_(p_93113_, (float)p_93114_, (float)p_93116_, (float)p_93118_).m_6122_(r, g, b, 255).m_7421_(p_93119_, p_93121_).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        }
    }

    public static class renderWithFloat {
        public static void blit(PoseStack p_93201_, float p_93202_, float p_93203_, float p_93204_, float p_93205_, float p_93206_, TextureAtlasSprite p_93207_) {
            renderWithFloat.innerBlit(p_93201_.m_85850_().m_85861_(), p_93202_, p_93202_ + p_93205_, p_93203_, p_93203_ + p_93206_, p_93204_, p_93207_.m_118409_(), p_93207_.m_118410_(), p_93207_.m_118411_(), p_93207_.m_118412_());
        }

        public void blit(PoseStack p_93229_, float p_93230_, float p_93231_, float blitOffset, float p_93232_, float p_93233_, float p_93234_, float p_93235_) {
            renderWithFloat.blit(p_93229_, p_93230_, p_93231_, blitOffset, p_93232_, p_93233_, p_93234_, p_93235_, 256.0f, 256.0f);
        }

        public static void blit(PoseStack p_93144_, float p_93145_, float p_93146_, float p_93147_, float p_93148_, float p_93149_, float p_93150_, float p_93151_, float p_93152_, float p_93153_) {
            renderWithFloat.innerBlit(p_93144_, p_93145_, p_93145_ + p_93150_, p_93146_, p_93146_ + p_93151_, p_93147_, p_93150_, p_93151_, p_93148_, p_93149_, p_93152_, p_93153_);
        }

        public static void blit(PoseStack p_93161_, float p_93162_, float p_93163_, float p_93164_, float p_93165_, float p_93166_, float p_93167_, float p_93168_, float p_93169_, float p_93170_, float p_93171_) {
            renderWithFloat.innerBlit(p_93161_, p_93162_, p_93162_ + p_93164_, p_93163_, p_93163_ + p_93165_, 0.0f, p_93168_, p_93169_, p_93166_, p_93167_, p_93170_, p_93171_);
        }

        public static void blit(PoseStack p_93134_, float p_93135_, float p_93136_, float p_93137_, float p_93138_, float p_93139_, float p_93140_, float p_93141_, float p_93142_) {
            renderWithFloat.blit(p_93134_, p_93135_, p_93136_, p_93139_, p_93140_, p_93137_, p_93138_, p_93139_, p_93140_, p_93141_, p_93142_);
        }

        private static void innerBlit(PoseStack p_93188_, float p_93189_, float p_93190_, float p_93191_, float p_93192_, float p_93193_, float p_93194_, float p_93195_, float p_93196_, float p_93197_, float p_93198_, float p_93199_) {
            renderWithFloat.innerBlit(p_93188_.m_85850_().m_85861_(), p_93189_, p_93190_, p_93191_, p_93192_, p_93193_, (p_93196_ + 0.0f) / p_93198_, (p_93196_ + p_93194_) / p_93198_, (p_93197_ + 0.0f) / p_93199_, (p_93197_ + p_93195_) / p_93199_);
        }

        private static void innerBlit(Matrix4f p_93113_, float p_93114_, float p_93115_, float p_93116_, float p_93117_, float p_93118_, float p_93119_, float p_93120_, float p_93121_, float p_93122_) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_85982_(p_93113_, p_93114_, p_93117_, p_93118_).m_7421_(p_93119_, p_93122_).m_5752_();
            bufferbuilder.m_85982_(p_93113_, p_93115_, p_93117_, p_93118_).m_7421_(p_93120_, p_93122_).m_5752_();
            bufferbuilder.m_85982_(p_93113_, p_93115_, p_93116_, p_93118_).m_7421_(p_93120_, p_93121_).m_5752_();
            bufferbuilder.m_85982_(p_93113_, p_93114_, p_93116_, p_93118_).m_7421_(p_93119_, p_93121_).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        }
    }
}

