/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.mrscauthd.beyond_earth.client.renderers.armors.JetSuitModel;
import net.mrscauthd.beyond_earth.client.renderers.armors.SpaceSuitModel;
import net.mrscauthd.beyond_earth.common.armors.ISpaceArmor;

@OnlyIn(value=Dist.CLIENT)
public class ClientMethods {
    public static boolean renderISpaceArmorArm(AbstractClientPlayer player, PlayerModel<AbstractClientPlayer> playerModel, PlayerRenderer renderer, PoseStack poseStack, MultiBufferSource bufferSource, int light, HumanoidArm arm) {
        ItemStack itemStack = player.m_6844_(EquipmentSlot.CHEST);
        Item item = itemStack.m_41720_();
        if (item instanceof ISpaceArmor) {
            ISpaceArmor spaceArmorItem = (ISpaceArmor)item;
            Model model = ForgeHooksClient.getArmorModel((LivingEntity)player, (ItemStack)itemStack, (EquipmentSlot)itemStack.getEquipmentSlot(), playerModel);
            if (model instanceof SpaceSuitModel.SpaceSuitP1) {
                SpaceSuitModel.SpaceSuitP1 spaceSuitModel = (SpaceSuitModel.SpaceSuitP1)model;
                ClientMethods.renderArmWithProperties(poseStack, bufferSource, light, spaceArmorItem.getTexture(itemStack, (LivingEntity)player), player, playerModel, renderer, arm == HumanoidArm.RIGHT ? spaceSuitModel.f_102811_ : spaceSuitModel.f_102812_);
                return true;
            }
            if (model instanceof JetSuitModel.JetSuitP1) {
                JetSuitModel.JetSuitP1 jetSuitModel = (JetSuitModel.JetSuitP1)model;
                ClientMethods.renderArmWithProperties(poseStack, bufferSource, light, spaceArmorItem.getTexture(itemStack, (LivingEntity)player), player, playerModel, renderer, arm == HumanoidArm.RIGHT ? jetSuitModel.f_102811_ : jetSuitModel.f_102812_);
                return true;
            }
        }
        return false;
    }

    public static void renderArmWithProperties(PoseStack poseStack, MultiBufferSource bufferSource, int light, ResourceLocation texture, AbstractClientPlayer player, PlayerModel<AbstractClientPlayer> playermodel, PlayerRenderer renderer, ModelPart arm) {
        renderer.m_117818_(player);
        playermodel.f_102608_ = 0.0f;
        playermodel.f_102817_ = false;
        playermodel.f_102818_ = 0.0f;
        playermodel.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        arm.f_104203_ = 0.0f;
        ItemStack item = player.m_6844_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)2));
        VertexConsumer vertex = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)item.m_41793_());
        arm.m_104301_(poseStack, vertex, light, OverlayTexture.f_118083_);
    }

    public static boolean isNotGuiSoundSource(SoundSource sound) {
        return sound == SoundSource.BLOCKS || sound == SoundSource.NEUTRAL || sound == SoundSource.RECORDS || sound == SoundSource.WEATHER || sound == SoundSource.HOSTILE || sound == SoundSource.PLAYERS || sound == SoundSource.AMBIENT;
    }

    public static void setBobView(PoseStack poseStack, float tick) {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.m_91288_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float f = player.f_19787_ - player.f_19867_;
            float f1 = -(player.f_19787_ + f * tick);
            float f2 = Mth.m_14179_((float)tick, (float)0.075f, (float)-0.075f);
            poseStack.m_85837_((double)(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 0.5f), (double)(-Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI)) * f2)), 0.0);
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 3.0f));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f));
        }
    }

    public static void sendPressKeyMessage() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        player.m_5661_((Component)Component.m_237115_((String)"message.beyond_earth.hold_key").m_130946_(" ").m_7220_(mc.f_91066_.f_92089_.getKey().m_84875_()), false);
    }
}

