/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.armors;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.mrscauthd.beyond_earth.client.renderers.armors.JetSuitModel;
import net.mrscauthd.beyond_earth.common.armors.ISpaceArmor;
import net.mrscauthd.beyond_earth.common.keybinds.KeyVariables;
import net.mrscauthd.beyond_earth.common.util.Methods;
import org.jetbrains.annotations.NotNull;

public class JetSuit {

    public static class Boots
    extends ISpaceArmor.Boots {
        public Boots(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    Map<String, ModelPart> map = Map.of("right_leg", new JetSuitModel.JetSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)JetSuitModel.JetSuitP1.LAYER_LOCATION)).f_102813_, "left_leg", new JetSuitModel.JetSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)JetSuitModel.JetSuitP1.LAYER_LOCATION)).f_102814_, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    JetSuitModel.JetSuitP1 armorModel = new JetSuitModel.JetSuitP1(modelPart, livingEntity, itemStack);
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/armor/jet_suit.png";
        }
    }

    public static class Pants
    extends ISpaceArmor.Leggings {
        public Pants(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    Map<String, ModelPart> map = Map.of("right_leg", new JetSuitModel.JetSuitP2<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)JetSuitModel.JetSuitP2.LAYER_LOCATION)).f_102813_, "left_leg", new JetSuitModel.JetSuitP2<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)JetSuitModel.JetSuitP2.LAYER_LOCATION)).f_102814_, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    JetSuitModel.JetSuitP2 armorModel = new JetSuitModel.JetSuitP2(modelPart, livingEntity, itemStack);
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/armor/jet_suit_pants.png";
        }
    }

    public static class Suit
    extends ISpaceArmor.Chestplate {
        public static final String TAG_MODE = "beyond_earth:jet_suit_mode";
        public float spacePressTime;

        public Suit(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    Map<String, ModelPart> map = Map.of("body", new JetSuitModel.JetSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)JetSuitModel.JetSuitP1.LAYER_LOCATION)).f_102810_, "right_arm", new JetSuitModel.JetSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)JetSuitModel.JetSuitP1.LAYER_LOCATION)).f_102811_, "left_arm", new JetSuitModel.JetSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)JetSuitModel.JetSuitP1.LAYER_LOCATION)).f_102812_, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    JetSuitModel.JetSuitP1 armorModel = new JetSuitModel.JetSuitP1(modelPart, livingEntity, itemStack);
                    return armorModel;
                }
            });
        }

        public int getMode(ItemStack itemStack) {
            return itemStack.m_41784_().m_128451_(TAG_MODE);
        }

        public ModeType getModeType(ItemStack itemStack) {
            int mode = this.getMode(itemStack);
            if (mode == 1) {
                return ModeType.NORMAL;
            }
            if (mode == 2) {
                return ModeType.HOVER;
            }
            if (mode == 3) {
                return ModeType.ELYTRA;
            }
            return ModeType.DISABLED;
        }

        public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
            return Methods.isLivingInJetSuit(entity) && this.getMode(stack) == ModeType.ELYTRA.getMode();
        }

        public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
            int nextFlightTick;
            if (!entity.f_19853_.f_46443_ && (nextFlightTick = flightTicks + 1) % 10 == 0) {
                entity.m_146850_(GameEvent.f_223705_);
            }
            return true;
        }

        @Override
        public void onArmorTick(ItemStack stack, Level level, Player player) {
            super.onArmorTick(stack, level, player);
            if (player.m_20142_()) {
                this.boost(player, 1.3, true);
            }
            if (player.f_20902_ > 0.0f && !player.m_20142_()) {
                this.boost(player, 0.9, false);
            }
            this.normalFlyModeMovement(player, stack);
            this.calculateSpacePressTime(player, stack);
        }

        public void normalFlyModeMovement(Player player, ItemStack stack) {
            if (!player.m_150110_().f_35935_ && !player.m_20159_() && Methods.isLivingInJetSuit((LivingEntity)player)) {
                if (this.getMode(stack) == ModeType.HOVER.getMode() && !player.m_21023_(MobEffects.f_19591_)) {
                    double gravity = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22115_();
                    Vec3 vec3 = player.m_20184_();
                    if (!player.m_20096_() && !player.isInFluidType()) {
                        player.m_20334_(vec3.f_82479_, vec3.f_82480_ + gravity - 0.005, vec3.f_82481_);
                        player.m_183634_();
                        Methods.disableFlyAntiCheat(player, true);
                    }
                    if (KeyVariables.isHoldingJump(player)) {
                        player.m_19920_(2.0f, new Vec3(0.0, 0.008, 0.0));
                        Methods.disableFlyAntiCheat(player, true);
                    }
                    if (!player.m_20096_() && player.m_6047_()) {
                        player.m_19920_(2.0f, new Vec3(0.0, -0.008, 0.0));
                        if (player instanceof LocalPlayer) {
                            LocalPlayer localPlayer = (LocalPlayer)player;
                            localPlayer.f_108601_ = false;
                        }
                    }
                    if (!player.m_20096_()) {
                        if (KeyVariables.isHoldingUp(player)) {
                            player.m_19920_(1.0f, new Vec3(0.0, 0.0, 0.01));
                        } else if (KeyVariables.isHoldingDown(player)) {
                            player.m_19920_(1.0f, new Vec3(0.0, 0.0, -0.01));
                        }
                    }
                    if (!player.m_20096_()) {
                        if (KeyVariables.isHoldingRight(player)) {
                            player.m_19920_(1.0f, new Vec3(-0.01, 0.0, 0.0));
                        } else if (KeyVariables.isHoldingLeft(player)) {
                            player.m_19920_(1.0f, new Vec3(0.01, 0.0, 0.0));
                        }
                    }
                }
                if (this.getMode(stack) == ModeType.NORMAL.getMode()) {
                    if (KeyVariables.isHoldingJump(player)) {
                        player.m_19920_(1.2f, new Vec3(0.0, 0.1, 0.0));
                        player.m_183634_();
                        Methods.disableFlyAntiCheat(player, true);
                    }
                    if (!player.m_20096_()) {
                        if (KeyVariables.isHoldingUp(player)) {
                            player.m_19920_(1.0f, new Vec3(0.0, 0.0, 0.03));
                        } else if (KeyVariables.isHoldingDown(player)) {
                            player.m_19920_(1.0f, new Vec3(0.0, 0.0, -0.03));
                        }
                    }
                    if (!player.m_20096_()) {
                        if (KeyVariables.isHoldingRight(player)) {
                            player.m_19920_(1.0f, new Vec3(-0.03, 0.0, 0.0));
                        } else if (KeyVariables.isHoldingLeft(player)) {
                            player.m_19920_(1.0f, new Vec3(0.03, 0.0, 0.0));
                        }
                    }
                }
            }
        }

        public void switchJetSuitMode(Player player, ItemStack itemStack) {
            CompoundTag compoundTag = itemStack.m_41784_();
            if (this.getMode(itemStack) < 3) {
                compoundTag.m_128405_(TAG_MODE, this.getMode(itemStack) + 1);
            } else {
                compoundTag.m_128405_(TAG_MODE, 0);
            }
        }

        public void calculateSpacePressTime(Player player, ItemStack itemStack) {
            int mode = this.getMode(itemStack);
            if (Methods.isLivingInJetSuit((LivingEntity)player)) {
                if (mode == ModeType.NORMAL.getMode()) {
                    if (KeyVariables.isHoldingJump(player)) {
                        if (this.spacePressTime < 2.2f) {
                            this.spacePressTime += 0.2f;
                        }
                    } else if (this.spacePressTime > 0.0f) {
                        this.spacePressTime -= 0.2f;
                    }
                }
                if (mode == ModeType.HOVER.getMode()) {
                    if (!player.m_20096_() && this.spacePressTime < 0.6f) {
                        this.spacePressTime += 0.2f;
                    } else if (KeyVariables.isHoldingJump(player)) {
                        if (this.spacePressTime < 1.4f) {
                            this.spacePressTime += 0.2f;
                        }
                    } else if (this.spacePressTime > 0.6f) {
                        this.spacePressTime -= 0.2f;
                    }
                }
                if (mode == ModeType.ELYTRA.getMode()) {
                    if (KeyVariables.isHoldingUp(player) && player.m_21255_()) {
                        if (player.m_20142_()) {
                            if (this.spacePressTime < 2.8f) {
                                this.spacePressTime += 0.2f;
                            }
                        } else if (this.spacePressTime < 2.2f) {
                            this.spacePressTime += 0.2f;
                        }
                    } else if (this.spacePressTime > 0.0f) {
                        this.spacePressTime -= 0.2f;
                    }
                }
            }
        }

        public void boost(Player player, double boost, boolean sonicBoom) {
            Vec3 vec31 = player.m_20154_();
            if (Methods.isLivingInJetSuit((LivingEntity)player) && player.m_21255_()) {
                Vec3 vec32 = player.m_20184_();
                player.m_20256_(vec32.m_82520_(vec31.f_82479_ * 0.1 + (vec31.f_82479_ * boost - vec32.f_82479_) * 0.5, vec31.f_82480_ * 0.1 + (vec31.f_82480_ * boost - vec32.f_82480_) * 0.5, vec31.f_82481_ * 0.1 + (vec31.f_82481_ * boost - vec32.f_82481_) * 0.5));
                if (sonicBoom) {
                    Vec3 vec33 = player.m_20154_().m_82490_(6.5);
                    if (player.f_19853_ instanceof ServerLevel) {
                        for (ServerPlayer p : ((ServerLevel)player.f_19853_).m_7654_().m_6846_().m_11314_()) {
                            ((ServerLevel)player.f_19853_).m_8624_(p, (ParticleOptions)ParticleTypes.f_123747_, true, player.m_20185_() - vec33.f_82479_, player.m_20186_() - vec33.f_82480_, player.m_20189_() - vec33.f_82481_, 1, 0.0, 0.0, 0.0, 0.001);
                        }
                    }
                }
            }
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/armor/jet_suit.png";
        }

        @Override
        public int getOxygenCapacity() {
            return 60000;
        }

        public static enum ModeType {
            DISABLED((Component)Component.m_237115_((String)"general.beyond_earth.jet_suit_disabled_mode"), ChatFormatting.RED, 0),
            NORMAL((Component)Component.m_237115_((String)"general.beyond_earth.jet_suit_normal_mode"), ChatFormatting.GREEN, 1),
            HOVER((Component)Component.m_237115_((String)"general.beyond_earth.jet_suit_hover_mode"), ChatFormatting.GREEN, 2),
            ELYTRA((Component)Component.m_237115_((String)"general.beyond_earth.jet_suit_elytra_mode"), ChatFormatting.GREEN, 3);

            private final int mode;
            private final ChatFormatting chatFormatting;
            private final Component component;

            private ModeType(Component component, ChatFormatting chatFormatting, int mode) {
                this.mode = mode;
                this.chatFormatting = chatFormatting;
                this.component = component;
            }

            public int getMode() {
                return this.mode;
            }

            public ChatFormatting getChatFormatting() {
                return this.chatFormatting;
            }

            public Component getTranslationKey() {
                return this.component;
            }
        }
    }

    public static class Helmet
    extends ISpaceArmor.Helmet {
        public Helmet(ArmorMaterial armorMaterial, EquipmentSlot equipmentSlot, Item.Properties properties) {
            super(armorMaterial, equipmentSlot, properties);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    Map<String, ModelPart> map = Map.of("head", new JetSuitModel.JetSuitP1<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)JetSuitModel.JetSuitP1.LAYER_LOCATION)).f_102808_, "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()));
                    ModelPart modelPart = new ModelPart(Collections.emptyList(), map);
                    JetSuitModel.JetSuitP1 armorModel = new JetSuitModel.JetSuitP1(modelPart, livingEntity, itemStack);
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "beyond_earth:textures/armor/jet_suit.png";
        }
    }
}

