/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.blocks.entities.machines;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.energy.IEnergyStorage;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.OxygenMakingBlockEntity;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.power.NamedComponentRegistry;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.power.PowerSystemEnergyCommon;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.power.PowerSystemRegistry;
import net.mrscauthd.beyond_earth.common.capabilities.energy.EnergyStorageBasic;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.ChunkOxygen;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.OxygenStorage;
import net.mrscauthd.beyond_earth.common.config.Config;
import net.mrscauthd.beyond_earth.common.data.recipes.BeyondEarthRecipeType;
import net.mrscauthd.beyond_earth.common.data.recipes.OxygenMakingRecipeAbstract;
import net.mrscauthd.beyond_earth.common.menus.OxygenBubbleDistributorMenu;
import net.mrscauthd.beyond_earth.common.registries.BlockEntityRegistry;
import net.mrscauthd.beyond_earth.common.registries.CapabilityRegistry;
import net.mrscauthd.beyond_earth.common.registries.RecipeTypeRegistry;

public class OxygenDistributorBlockEntity
extends OxygenMakingBlockEntity {
    public static final int DEFAULT_ENERGY_USAGE = 1;
    public static final int DEFAULT_ENERGY_USAGE_PER_RANGE = 0;
    public static final int DEFAULT_RANGE_MIN = 1;
    public static final int DEFAULT_RANGE_MAX = 15;
    public static final String KEY_TIMER = "timer";
    public static final String KEY_RANGE = "range";
    public static final String KEY_WORKINGAREA_VISIBLE = "workingAreaVisible";
    public static final int MAX_TIMER = 4;

    public OxygenDistributorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.OXYGEN_BUBBLE_DISTRIBUTOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    protected boolean canActivated() {
        if (this.getOutputTank().getOxygen() >= (Integer)Config.OXYGEN_BUBBLE_DISTRIBUTOR_RATE_OUTPUT.get()) {
            return true;
        }
        return super.canActivated();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82377_(32.0, 32.0, 32.0);
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new OxygenBubbleDistributorMenu.GuiContainer(id, inventory, this);
    }

    @Override
    protected void createEnergyStorages(NamedComponentRegistry<IEnergyStorage> registry) {
        super.createEnergyStorages(registry);
        int capacity = (Integer)Config.OXYGEN_BUBBLE_DISTRIBUTOR_ENERGY_CAPACITY.get();
        int maxTransfer = (Integer)Config.OXYGEN_BUBBLE_DISTRIBUTOR_ENERGY_TRANSFER.get();
        registry.put((IEnergyStorage)new EnergyStorageBasic(this, capacity, maxTransfer, capacity));
    }

    @Override
    protected int getInitialTankCapacity(ResourceLocation name) {
        if (name.equals((Object)this.getInputTankName())) {
            return (Integer)Config.OXYGEN_BUBBLE_DISTRIBUTOR_TANK_FLUID_CAPACITY.get();
        }
        if (name.equals((Object)this.getOutputTankName())) {
            return (Integer)Config.OXYGEN_BUBBLE_DISTRIBUTOR_TANK_OXYGEN_CAPACITY.get();
        }
        return super.getInitialTankCapacity(name);
    }

    @Override
    public int getTransferPerTick() {
        return (Integer)Config.OXYGEN_BUBBLE_DISTRIBUTOR_TANK_TRANSFER.get();
    }

    @Override
    protected void tickProcessing() {
        super.tickProcessing();
        this.tickDistributeTimer();
    }

    private void tickDistributeTimer() {
        if (this.getTimer() >= this.getMaxTimer()) {
            this.setTimer(0);
            this.distribute();
        }
        this.setTimer(this.getTimer() + 1);
    }

    private void distribute() {
        OxygenStorage oxygenStorage = this.getOutputTank();
        ChunkOxygen chunkO2 = (ChunkOxygen)((LevelChunk)this.f_58857_.m_46865_(this.m_58899_())).getCapability(CapabilityRegistry.CHUNK_OXYGEN).orElse(null);
        if (chunkO2.hasInfiniteO2()) {
            oxygenStorage.receiveOxygen((Integer)Config.OXYGEN_BUBBLE_DISTRIBUTOR_RATE_INPUT.get(), false);
            return;
        }
        int oxygenUsing = (Integer)Config.OXYGEN_BUBBLE_DISTRIBUTOR_RATE_OUTPUT.get();
        int O2Provided = oxygenStorage.extractOxygen(oxygenUsing, true);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            int remaining = chunkO2.addO2(this.m_58899_(), (byte)O2Provided, true);
            int removed = O2Provided - remaining;
            oxygenStorage.extractOxygen(removed, false);
            Vec3 center = new AABB(this.m_58899_()).m_82399_();
            if (removed > 0) {
                serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, center.f_82479_, center.f_82480_ + 0.5, center.f_82481_, 1, 0.1, 0.1, 0.1, 0.001);
                this.setProcessedInThisTick();
            }
        }
    }

    public int getMaxTimer() {
        return 4;
    }

    public int getTimer() {
        return this.getPersistentData().m_128451_(KEY_TIMER);
    }

    public void setTimer(int timer) {
        timer = Math.max(timer, 0);
        if (this.getTimer() != timer) {
            this.getPersistentData().m_128405_(KEY_TIMER, timer);
            this.m_6596_();
        }
    }

    @Override
    protected void createPowerSystems(PowerSystemRegistry map) {
        super.createPowerSystems(map);
        map.put(new PowerSystemEnergyCommon(this){

            @Override
            public int getBasePowerForOperation() {
                return OxygenDistributorBlockEntity.this.getBasePowerForOperation();
            }
        });
    }

    public int getBasePowerForOperation() {
        return (Integer)Config.OXYGEN_BUBBLE_DISTRIBUTOR_ENERGY_USAGE.get();
    }

    @Override
    public BeyondEarthRecipeType<? extends OxygenMakingRecipeAbstract> getRecipeType() {
        return (BeyondEarthRecipeType)RecipeTypeRegistry.OXYGEN_BUBBLE_DISTRIBUTING.get();
    }
}

