/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.IGaugeValue;

public class GaugeValueSimple
implements IGaugeValue {
    public static final int FALLBACK_COLOR = -1593835521;
    private ResourceLocation name;
    private int amount;
    private int capacity;
    private Component displayeName;
    private String unit;
    private int color;
    private boolean reverse;
    private Component displayNameCache;

    public GaugeValueSimple() {
        this(null);
    }

    public GaugeValueSimple(@Nonnull ResourceLocation name) {
        this(name, 0, 0);
    }

    public GaugeValueSimple(@Nonnull ResourceLocation name, int amount, int capacity) {
        this(name, amount, capacity, null);
    }

    public GaugeValueSimple(@Nonnull ResourceLocation name, int amount, int capacity, @Nullable Component displayeName) {
        this(name, amount, capacity, displayeName, "");
    }

    public GaugeValueSimple(@Nonnull ResourceLocation name, int amount, int capacity, @Nullable Component displayeName, @Nonnull String unit) {
        this(name, amount, capacity, displayeName, unit, -1593835521);
    }

    public GaugeValueSimple(@Nonnull ResourceLocation name, int amount, int capacity, @Nullable Component displayeName, @Nonnull String unit, int color) {
        this.name = name;
        this.amount = amount;
        this.capacity = capacity;
        this.displayeName = displayeName;
        this.unit = unit;
        this.color = color;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("name", this.getName().toString());
        compound.m_128405_("amount", this.getAmount());
        compound.m_128405_("capacity", this.getCapacity());
        if (this.getDisplayName() != null) {
            compound.m_128359_("displayName", Component.Serializer.m_130703_((Component)this.getDisplayName()));
        }
        compound.m_128359_("unit", this.getUnit());
        compound.m_128405_("color", this.getColor());
        compound.m_128379_("reverse", this.isReverse());
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.name(new ResourceLocation(compound.m_128461_("name")));
        this.amount(compound.m_128451_("amount"));
        this.capacity(compound.m_128451_("capacity"));
        if (compound.m_128441_("displayName")) {
            this.displayeName((Component)Component.Serializer.m_130701_((String)compound.m_128461_("displayName")));
        }
        this.unit(compound.m_128461_("unit"));
        this.color(compound.m_128451_("color"));
        this.reverse(compound.m_128471_("reverse"));
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public GaugeValueSimple name(@Nonnull ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Override
    @Nullable
    public Component getDisplayName() {
        if (this.displayeName != null) {
            return this.displayeName;
        }
        if (this.displayNameCache == null) {
            this.displayNameCache = this.createDefaultTextComponent();
        }
        return this.displayNameCache;
    }

    protected Component createDefaultTextComponent() {
        return Component.m_237115_((String)GaugeValueHelper.makeTranslationKey(this.getName()));
    }

    public GaugeValueSimple displayeName(@Nullable Component displayeName) {
        this.displayeName = displayeName;
        return this;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public GaugeValueSimple unit(@Nonnull String unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    public GaugeValueSimple amount(int amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public GaugeValueSimple capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public GaugeValueSimple color(int color) {
        this.color = color;
        return this;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    public GaugeValueSimple reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }
}

