/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.blocks.machines;

import java.util.Collections;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.AbstractMachineBlockEntity;

public abstract class AbstractMachineBlock<T extends AbstractMachineBlockEntity>
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public AbstractMachineBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_((ToIntFunction)new ToIntFunction<BlockState>(){

            @Override
            public int applyAsInt(BlockState state) {
                Block block = state.m_60734_();
                if (block instanceof AbstractMachineBlock) {
                    return ((AbstractMachineBlock)block).getLightLevel(state);
                }
                return 0;
            }
        }));
        this.m_49959_(this.buildDefaultState());
    }

    protected BlockState buildDefaultState() {
        BlockState any = (BlockState)this.f_49792_.m_61090_();
        if (this.useFacing()) {
            any = (BlockState)any.m_61124_((Property)FACING, (Comparable)Direction.NORTH);
        }
        if (this.useLit()) {
            any = (BlockState)any.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return any;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        if (this.useFacing()) {
            builder.m_61104_(new Property[]{FACING});
        }
        if (this.useLit()) {
            builder.m_61104_(new Property[]{LIT});
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (this.useFacing()) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        if (this.useFacing()) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        }
        return state;
    }

    protected int getLightLevel(BlockState state) {
        if (this.useLit()) {
            return (Boolean)state.m_61143_((Property)LIT) != false ? 12 : 0;
        }
        return 0;
    }

    protected boolean useFacing() {
        return false;
    }

    protected boolean useLit() {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult raytrace) {
        if (entity instanceof ServerPlayer) {
            T blockEntity = this.getBlockEntity(level, pos);
            if (blockEntity != null) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)entity), blockEntity, (BlockPos)pos);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public T getBlockEntity(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractMachineBlockEntity) {
            return (T)((AbstractMachineBlockEntity)blockEntity);
        }
        return null;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockEntity instanceof AbstractMachineBlockEntity) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            blockEntity.m_187476_(itemStack);
            return Collections.singletonList(itemStack);
        }
        return super.m_7381_(state, builder);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public abstract T newBlockEntity(BlockPos var1, BlockState var2);

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public <T2 extends BlockEntity> BlockEntityTicker<T2> m_142354_(Level level, BlockState state, BlockEntityType<T2> type) {
        return (l, p, s, e) -> {
            if (e instanceof AbstractMachineBlockEntity) {
                ((AbstractMachineBlockEntity)e).tick();
            }
        };
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractMachineBlockEntity) {
            return AbstractContainerMenu.m_38938_((Container)((AbstractMachineBlockEntity)blockEntity));
        }
        return 0;
    }
}

