/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.capabilities.oxygen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.common.registries.CapabilityRegistry;
import net.mrscauthd.beyond_earth.common.util.Methods;
import net.mrscauthd.beyond_earth.common.util.Planets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="beyond_earth")
public class ChunkOxygen
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final Int2ObjectArrayMap<SectionOxygen> O2 = new Int2ObjectArrayMap();
    private final Level level;
    private final boolean infiniteO2;
    private final Planets.Planet planet;
    private final LazyOptional<ChunkOxygen> cap = LazyOptional.of(() -> this);

    @SubscribeEvent
    public static void onChunkCapababilityAttach(AttachCapabilitiesEvent<LevelChunk> event) {
        event.addCapability(new ResourceLocation("beyond_earth", "chunk_oxygen"), (ICapabilityProvider)new ChunkOxygen(((LevelChunk)event.getObject()).m_62953_()));
    }

    public static boolean isBreatheable(int O2) {
        return O2 > 30;
    }

    public static boolean isVacuum(int O2) {
        return O2 <= 30 && O2 >= 0;
    }

    public ChunkOxygen(Level level) {
        this.level = level;
        this.infiniteO2 = !Methods.isSpaceLevelWithoutOxygen(level);
        this.planet = Planets.getLocationForPlanet(level);
    }

    public int getO2(BlockPos pos) {
        if (this.infiniteO2) {
            if (this.planet == null) {
                return 100;
            }
            int y = pos.m_123342_();
            int base = 100;
            int dy = this.level.m_5736_();
            float g = this.planet.g;
            float T = this.planet.temperature + 273.15f;
            int h = y - dy;
            return (int)((double)base * Math.exp((double)(-g) * 1.5 * (double)h / (double)T));
        }
        int y = SectionPos.m_123171_((int)pos.m_123342_());
        SectionOxygen oxygen = (SectionOxygen)this.O2.computeIfAbsent(y, newY -> new SectionOxygen());
        return oxygen.getO2(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public boolean hasInfiniteO2() {
        return this.infiniteO2;
    }

    public int addO2(BlockPos pos, int toAdd, boolean spread) {
        if (this.infiniteO2) {
            return toAdd > 0 ? toAdd : 0;
        }
        int ret = 0;
        int O2 = this.getO2(pos);
        int newO2 = 0;
        int tmpO2 = O2 + toAdd;
        if (tmpO2 > 255) {
            ret = tmpO2 - 255;
            newO2 = 255;
        } else if (tmpO2 > 0) {
            newO2 = tmpO2;
        }
        int y = SectionPos.m_123171_((int)pos.m_123342_());
        SectionOxygen oxygen = (SectionOxygen)this.O2.computeIfAbsent(y, newY -> new SectionOxygen());
        oxygen.setO2(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), newO2);
        SectionPos section = SectionPos.m_123199_((BlockPos)pos);
        Object2ObjectOpenHashMap nearby = new Object2ObjectOpenHashMap();
        nearby.put(section, oxygen);
        for (Direction d : Direction.values()) {
            SectionPos relative = section.m_7918_(d.m_122429_(), d.m_122430_(), d.m_122431_());
            if (!this.level.m_7232_(relative.m_123341_(), relative.m_123343_())) continue;
            LevelChunk chunk = this.level.m_6325_(relative.m_123341_(), relative.m_123343_());
            ChunkOxygen chunkO2 = (ChunkOxygen)chunk.getCapability(CapabilityRegistry.CHUNK_OXYGEN).orElse(null);
            nearby.put(relative, (SectionOxygen)chunkO2.O2.computeIfAbsent(relative.m_123342_(), newY -> new SectionOxygen()));
        }
        if (spread) {
            oxygen.propagate((Map<SectionPos, SectionOxygen>)nearby, DefaultCheck.DEFAULTS, pos, this.level);
        }
        return ret;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.O2.forEach((i, o2) -> tag.m_128365_("" + i, (Tag)o2.serializeNBT()));
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        nbt.m_128431_().forEach(s -> {
            try {
                int i = Integer.parseInt(s);
                byte[] o2 = nbt.m_128463_(s);
                this.O2.put(i, (Object)new SectionOxygen(o2));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        });
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CapabilityRegistry.CHUNK_OXYGEN.orEmpty(cap, this.cap);
    }

    public class SectionOxygen
    implements INBTSerializable<ByteArrayTag> {
        byte[] O2 = new byte[4096];

        public SectionOxygen() {
            Arrays.fill(this.O2, (byte)-128);
        }

        public SectionOxygen(byte[] O2) {
            this();
            this.O2 = O2;
        }

        public ByteArrayTag serializeNBT() {
            return new ByteArrayTag(this.O2);
        }

        public void deserializeNBT(ByteArrayTag nbt) {
            this.O2 = nbt.m_128227_();
        }

        private void propagate(Map<SectionPos, SectionOxygen> nearby, Function<AirCheckTest, AirCheckResult> shouldSpread, BlockPos origin, Level level, int depth) {
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverlevel = (ServerLevel)level;
            BlockPos.MutableBlockPos testPoint = new BlockPos.MutableBlockPos();
            HashMap dirty = Maps.newHashMap();
            int x = origin.m_123341_();
            int y = origin.m_123342_();
            int z = origin.m_123343_();
            int index = x & 0xF | (y & 0xF) << 4 | (z & 0xF) << 8;
            int amt = this.getO2(index);
            Direction minDown = null;
            int dO2max = 1;
            int total = amt;
            for (Direction d : Direction.values()) {
                int x2 = x + d.m_122429_();
                int y2 = y + d.m_122430_();
                int z2 = z + d.m_122431_();
                testPoint.m_122159_((Vec3i)origin, d);
                AirCheckTest checkTest = new AirCheckTest((BlockPos)testPoint, minDown, serverlevel);
                AirCheckResult checkResult = shouldSpread.apply(checkTest);
                if (checkResult.solid()) continue;
                SectionPos pos2 = SectionPos.m_123199_((BlockPos)testPoint);
                SectionOxygen flowTo = this;
                int index2 = x2 & 0xF | (y2 & 0xF) << 4 | (z2 & 0xF) << 8;
                if (x2 > 15 || x2 < 0 || y2 > 15 || y2 < 0 || z2 > 15 || z2 < 0) {
                    flowTo = nearby.get(pos2);
                }
                if (flowTo == null) continue;
                int oldAmt = flowTo.getO2(index2);
                oldAmt = Math.min(255, checkResult.amount() + oldAmt);
                int dO2 = Math.abs(amt - oldAmt);
                if (dO2 <= dO2max) continue;
                minDown = d;
                dO2max = dO2;
                total = amt + oldAmt;
            }
            if (minDown != null) {
                int old;
                int newAmt = total / 2;
                int x2 = x + minDown.m_122429_();
                int y2 = y + minDown.m_122430_();
                int z2 = z + minDown.m_122431_();
                testPoint.m_122159_((Vec3i)origin, minDown);
                SectionOxygen flowTo = this;
                int index2 = x2 & 0xF | (y2 & 0xF) << 4 | (z2 & 0xF) << 8;
                if (x2 > 15 || x2 < 0 || y2 > 15 || y2 < 0 || z2 > 15 || z2 < 0) {
                    flowTo = nearby.get(SectionPos.m_123199_((BlockPos)testPoint));
                }
                if ((old = flowTo.getO2(index2)) != newAmt) {
                    flowTo.setO2(index2, newAmt);
                    dirty.put(testPoint.m_7949_(), flowTo);
                    if (Math.abs(amt - newAmt) > 5) {
                        serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)testPoint.m_123341_(), (double)testPoint.m_123342_() + 0.5, (double)testPoint.m_123343_(), 1, 0.0, 0.1, 0.0, 0.001);
                    }
                }
                if (newAmt != amt) {
                    this.setO2(index, newAmt + total % 2);
                    if (Math.abs(amt - newAmt) > 5) {
                        serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)origin.m_123341_(), (double)origin.m_123342_() + 0.5, (double)origin.m_123343_(), 1, 0.1, 0.1, 0.1, 0.001);
                    }
                }
            }
            if (depth < 10 && !dirty.isEmpty()) {
                dirty.forEach((pos, section) -> section.propagate(nearby, shouldSpread, (BlockPos)pos, level, depth + 1));
                this.propagate(nearby, shouldSpread, origin, (Level)serverlevel, depth + 1);
            }
        }

        public void propagate(Map<SectionPos, SectionOxygen> nearby, Function<AirCheckTest, AirCheckResult> shouldSpread, BlockPos origin, Level level) {
            this.propagate(nearby, shouldSpread, origin, level, 0);
        }

        private void setO2(int index, int amt) {
            byte set;
            this.O2[index] = set = (byte)Mth.m_14045_((int)(amt + -128), (int)-128, (int)127);
        }

        private int getO2(int index) {
            return this.O2[index] - -128;
        }

        private int getO2(int x, int y, int z) {
            int index = x & 0xF | (y & 0xF) << 4 | (z & 0xF) << 8;
            return this.getO2(index);
        }

        public void setO2(int x, int y, int z, int amt) {
            int index = x & 0xF | (y & 0xF) << 4 | (z & 0xF) << 8;
            this.setO2(index, amt);
        }
    }

    public static class DefaultCheck
    implements Function<AirCheckTest, AirCheckResult> {
        private static final AirCheckResult OPEN = new AirCheckResult(false, true, 0);
        private static final AirCheckResult BLOCKED = new AirCheckResult(true, true, 0);
        private static final AirCheckResult LEAVES = new AirCheckResult(false, false, 1);
        public static final DefaultCheck DEFAULTS = new DefaultCheck();
        public List<Function<AirCheckTest, AirCheckResult>> children = Lists.newArrayList();

        @Override
        public AirCheckResult apply(AirCheckTest t) {
            for (Function<AirCheckTest, AirCheckResult> child : this.children) {
                AirCheckResult result = child.apply(t);
                if (result.pass()) continue;
                return result;
            }
            BlockState state = t.level.m_8055_(t.pos());
            if (state.m_204336_(BlockTags.f_13035_)) {
                return LEAVES;
            }
            boolean airTight = state.m_60838_((BlockGetter)t.level, t.pos());
            return airTight ? BLOCKED : OPEN;
        }
    }

    public record AirCheckResult(boolean solid, boolean pass, int amount) {
    }

    public record AirCheckTest(BlockPos pos, Direction from, ServerLevel level) {
    }
}

