/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.capabilities.oxygen;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.IOxygenStorageHolder;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.OxygenStorage;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.OxygenUtil;

public class OxygenProvider
implements ICapabilityProvider,
IOxygenStorageHolder {
    public static Capability<OxygenStorage> OXYGEN = CapabilityManager.get((CapabilityToken)new CapabilityToken<OxygenStorage>(){});
    public static final String KEY_OXYGEN = "Energy";
    private ItemStack itemStack;
    private IOxygenStorage oxygenStorage;

    public OxygenProvider(ItemStack itemStack, int capacity) {
        this.itemStack = itemStack;
        this.oxygenStorage = new OxygenStorage(this, capacity);
        this.readOxygen();
    }

    private void readOxygen() {
        CompoundTag compound = this.getItemStack().m_41784_();
        this.getOxygenStorage().setOxygen(compound.m_128451_(KEY_OXYGEN));
    }

    public void writeOxygen() {
        CompoundTag compound = this.getItemStack().m_41784_();
        compound.m_128405_(KEY_OXYGEN, this.getOxygenStorage().getOxygen());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
        LazyOptional<T> oxygenCapability = OxygenUtil.getOxygenCapability(capability, (NonNullSupplier<IOxygenStorage>)((NonNullSupplier)this::getOxygenStorage));
        if (oxygenCapability.isPresent()) {
            return oxygenCapability;
        }
        return LazyOptional.empty();
    }

    @Override
    public void onOxygenChanged(IOxygenStorage oxygenStorage, int oxygenDelta) {
        this.writeOxygen();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public IOxygenStorage getOxygenStorage() {
        return this.oxygenStorage;
    }
}

