/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.compats.waila;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.mrscauthd.beyond_earth.client.screens.helper.gauge.GaugeValueRenderer;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeValueSerializer;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.common.compats.waila.BlockDataProvider;
import net.mrscauthd.beyond_earth.common.compats.waila.EntityDataProvider;
import net.mrscauthd.beyond_earth.common.compats.waila.GaugeValueElement;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.ui.IElement;

@snownee.jade.api.WailaPlugin
public class WailaPlugin
implements IWailaPlugin {
    public static final ResourceLocation DATA_KEY = new ResourceLocation("beyond_earth", "waila_datakey");

    public static ListTag write(List<IGaugeValue> list) {
        ListTag nbt = new ListTag();
        list.stream().map(GaugeValueSerializer.Serializer::serialize).forEach(arg_0 -> nbt.add(arg_0));
        return nbt;
    }

    public static List<IGaugeValue> read(ListTag nbt) {
        ArrayList<IGaugeValue> list = new ArrayList<IGaugeValue>();
        nbt.stream().map(h -> (CompoundTag)h).map(GaugeValueSerializer.Serializer::deserialize).forEach(list::add);
        return list;
    }

    public static ListTag get(CompoundTag compound) {
        return compound.m_128437_(DATA_KEY.toString(), 10);
    }

    public static void put(CompoundTag compound, ListTag nbt) {
        compound.m_128365_(DATA_KEY.toString(), (Tag)nbt);
    }

    public static void appendTooltip(ITooltip tooltip, CompoundTag serverData) {
        ListTag list = WailaPlugin.get(serverData);
        for (int i = 0; i < list.size(); ++i) {
            IGaugeValue value = GaugeValueSerializer.Serializer.deserialize(list.m_128728_(i));
            tooltip.add((IElement)new GaugeValueElement(new GaugeValueRenderer(value)));
        }
    }

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)BlockDataProvider.INSTANCE, BlockEntity.class);
        registration.registerEntityDataProvider((IServerDataProvider)EntityDataProvider.INSTANCE, Entity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)BlockDataProvider.INSTANCE, Block.class);
        registration.registerEntityComponent((IEntityComponentProvider)EntityDataProvider.INSTANCE, Entity.class);
    }
}

