/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.data.recipes;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.common.data.recipes.BeyondEarthRecipe;
import net.mrscauthd.beyond_earth.common.entities.alien.AlienTrade;
import org.apache.commons.lang3.tuple.Triple;

public abstract class AlienTradingRecipe
extends BeyondEarthRecipe {
    private final VillagerProfession job;
    private final int level;
    private final int xp;
    private final int maxUses;
    private final float priceMultiplier;

    public AlienTradingRecipe(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.job = (VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"job")));
        this.level = GsonHelper.m_13927_((JsonObject)json, (String)"level");
        this.xp = GsonHelper.m_13927_((JsonObject)json, (String)"xp");
        this.maxUses = GsonHelper.m_13824_((JsonObject)json, (String)"maxUses", (int)AlienTrade.MAX_USES);
        this.priceMultiplier = GsonHelper.m_13820_((JsonObject)json, (String)"priceMultiplier", (float)0.05f);
    }

    public AlienTradingRecipe(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
        this.job = (VillagerProfession)buffer.readRegistryId();
        this.level = buffer.readInt();
        this.xp = buffer.readInt();
        this.maxUses = buffer.readInt();
        this.priceMultiplier = buffer.readFloat();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeRegistryId(ForgeRegistries.VILLAGER_PROFESSIONS, (Object)this.job);
        buffer.writeInt(this.level);
        buffer.writeInt(this.xp);
        buffer.writeInt(this.maxUses);
        buffer.writeFloat(this.priceMultiplier);
    }

    public abstract Triple<ItemStack, ItemStack, ItemStack> getTrade(Entity var1, RandomSource var2);

    public boolean m_8004_(int p_194133_1_, int p_194133_2_) {
        return true;
    }

    public VillagerProfession getJob() {
        return this.job;
    }

    public int getLevel() {
        return this.level;
    }

    public int getXP() {
        return this.xp;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public float getPriceMultiplier() {
        return this.priceMultiplier;
    }
}

