/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.mrscauthd.beyond_earth.common.data.recipes.BeyondEarthRecipe;

public abstract class ItemStackToItemStackRecipe
extends BeyondEarthRecipe
implements Predicate<ItemStack> {
    private final Ingredient input;
    private final ItemStack output;
    private final int cookTime;

    public ItemStackToItemStackRecipe(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        this.output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)true);
        this.cookTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookTime", (int)this.getDefaultCookTime());
    }

    public ItemStackToItemStackRecipe(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
        this.input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        this.output = buffer.m_130267_();
        this.cookTime = buffer.readInt();
    }

    public ItemStackToItemStackRecipe(ResourceLocation id, Ingredient ingredient, ItemStack output, int cookTime) {
        super(id);
        this.input = ingredient;
        this.output = output.m_41777_();
        this.cookTime = cookTime;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.getInput().m_43923_(buffer);
        buffer.m_130055_(this.getOutput());
        buffer.writeInt(this.getCookTime());
    }

    protected int getDefaultCookTime() {
        return 200;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.input.test(stack);
    }

    public boolean m_8004_(int var1, int var2) {
        return true;
    }

    @Override
    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = super.m_7527_();
        list.add((Object)this.getInput());
        return list;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getCookTime() {
        return this.cookTime;
    }
}

