/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.data.recipes;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.mrscauthd.beyond_earth.common.data.recipes.BeyondEarthRecipe;
import net.mrscauthd.beyond_earth.common.data.recipes.RocketPart;
import net.mrscauthd.beyond_earth.common.menus.nasaworkbench.RocketPartsItemHandler;
import net.mrscauthd.beyond_earth.common.registries.RecipeSerializersRegistry;
import net.mrscauthd.beyond_earth.common.registries.RecipeTypeRegistry;
import net.mrscauthd.beyond_earth.common.registries.RocketPartsRegistry;

public class WorkbenchingRecipe
extends BeyondEarthRecipe
implements BiPredicate<RocketPartsItemHandler, Boolean> {
    private final Map<RocketPart, List<Ingredient>> parts;
    private final ItemStack output;

    public WorkbenchingRecipe(ResourceLocation id, JsonObject json) {
        super(id, json);
        JsonObject inputJson = GsonHelper.m_13930_((JsonObject)json, (String)"input");
        JsonObject partsJson = GsonHelper.m_13930_((JsonObject)inputJson, (String)"parts");
        HashMap map = new HashMap();
        for (Map.Entry entry : partsJson.entrySet()) {
            RocketPart part = (RocketPart)RocketPartsRegistry.ROCKET_PARTS_REGISTRY.get().getValue(new ResourceLocation((String)entry.getKey()));
            JsonArray slotsJson = ((JsonElement)entry.getValue()).getAsJsonArray();
            List ingredients = Lists.newArrayList((Iterable)slotsJson).stream().map(Ingredient::m_43917_).collect(Collectors.toList());
            map.put(part, Collections.unmodifiableList(ingredients));
        }
        this.parts = Collections.unmodifiableMap(map);
        this.output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)true);
    }

    public WorkbenchingRecipe(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, buffer);
        int partsSize = buffer.readInt();
        HashMap map = new HashMap();
        for (int i = 0; i < partsSize; ++i) {
            RocketPart part = (RocketPart)buffer.readRegistryId();
            int ingredientsSize = buffer.readInt();
            List ingredients = Arrays.stream(new Ingredient[ingredientsSize]).map(in -> Ingredient.m_43940_((FriendlyByteBuf)buffer)).collect(Collectors.toList());
            map.put(part, Collections.unmodifiableList(ingredients));
        }
        this.parts = Collections.unmodifiableMap(map);
        this.output = buffer.m_130267_();
    }

    public WorkbenchingRecipe(ResourceLocation id, Map<RocketPart, List<Ingredient>> parts, ItemStack output) {
        super(id);
        HashMap<RocketPart, List<Ingredient>> map = new HashMap<RocketPart, List<Ingredient>>();
        for (Map.Entry<RocketPart, List<Ingredient>> entry : parts.entrySet()) {
            map.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        this.parts = Collections.unmodifiableMap(map);
        this.output = output.m_41777_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeInt(this.parts.size());
        for (Map.Entry<RocketPart, List<Ingredient>> entry : this.parts.entrySet()) {
            buffer.writeRegistryId(RocketPartsRegistry.ROCKET_PARTS_REGISTRY.get(), (Object)entry.getKey());
            List<Ingredient> ingredients = entry.getValue();
            buffer.writeInt(ingredients.size());
            ingredients.forEach(i -> i.m_43923_(buffer));
        }
        buffer.m_130055_(this.output);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = super.m_7527_();
        ingredients.addAll((Collection)this.parts.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList()));
        return ingredients;
    }

    public boolean m_8004_(int var1, int var2) {
        return false;
    }

    @Override
    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public Map<RocketPart, List<Ingredient>> getParts() {
        return this.parts;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersRegistry.RECIPE_SERIALIZER_NASA_WORKBENCH.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.NASA_WORKBENCHING.get();
    }

    public boolean test(RocketPartsItemHandler itemHandler) {
        return this.test(itemHandler, false);
    }

    @Override
    public boolean test(RocketPartsItemHandler itemHandler, Boolean ignoreAir) {
        for (Map.Entry<RocketPart, List<Ingredient>> entry : this.getParts().entrySet()) {
            List<Ingredient> ingredients;
            RocketPart part = entry.getKey();
            IItemHandlerModifiable subHandler = itemHandler.getSubHandlers().get(part);
            if (subHandler == null) {
                return false;
            }
            int subHandlerSlots = subHandler.getSlots();
            if (subHandlerSlots < (ingredients = entry.getValue()).size()) {
                return false;
            }
            for (int i = 0; i < subHandlerSlots; ++i) {
                if (i >= ingredients.size()) continue;
                ItemStack stack = subHandler.getStackInSlot(i);
                Ingredient ingredient = ingredients.get(i);
                if (ignoreAir.booleanValue() && stack.m_41619_() || ingredient.test(stack)) continue;
                return false;
            }
        }
        return true;
    }
}

