/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.entities;

import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.mrscauthd.beyond_earth.common.blocks.RocketLaunchPad;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.IGaugeValuesProvider;
import net.mrscauthd.beyond_earth.common.entities.IVehicleEntity;
import net.mrscauthd.beyond_earth.common.events.forge.SetPlanetSelectionMenuNeededNbtEvent;
import net.mrscauthd.beyond_earth.common.keybinds.KeyVariables;
import net.mrscauthd.beyond_earth.common.menus.RocketMenu;
import net.mrscauthd.beyond_earth.common.registries.SoundRegistry;
import net.mrscauthd.beyond_earth.common.registries.TagRegistry;
import net.mrscauthd.beyond_earth.common.util.Methods;

public abstract class IRocketEntity
extends IVehicleEntity
implements HasCustomInventoryScreen,
IGaugeValuesProvider {
    public static final EntityDataAccessor<Boolean> ROCKET_START = SynchedEntityData.m_135353_(IRocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> FUEL = SynchedEntityData.m_135353_(IRocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> START_TIMER = SynchedEntityData.m_135353_(IRocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemStackHandler inventory = new ItemStackHandler(10){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory});

    public IRocketEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19804_.m_135372_(ROCKET_START, (Object)false);
        this.f_19804_.m_135372_(FUEL, (Object)0);
        this.f_19804_.m_135372_(START_TIMER, (Object)0);
    }

    public abstract double getRocketSpeed();

    public abstract int getTier();

    public abstract int getBucketsOfFull();

    public int getFuelCapacity() {
        return this.getBucketsOfFull() * 1000;
    }

    public IGaugeValue getFuelGauge() {
        int fuel = (Integer)this.m_20088_().m_135370_(FUEL);
        int capacity = this.getFuelCapacity();
        return GaugeValueHelper.getFuel(fuel, capacity);
    }

    @Override
    public List<IGaugeValue> getDisplayGaugeValues() {
        return Collections.singletonList(this.getFuelGauge());
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public void m_7334_(Entity p_21294_) {
    }

    public void m_6074_() {
        this.dropEquipment();
        this.spawnRocketItem();
        if (!this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_6469_(DamageSource source, float p_21017_) {
        Entity sourceEntity = source.m_7639_();
        if (!source.m_19360_() && sourceEntity != null && sourceEntity.m_6047_() && !this.m_20160_()) {
            this.spawnRocketItem();
            this.dropEquipment();
            if (!this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    public abstract ItemStack getRocketItem();

    public ItemStack getPickedResult(HitResult target) {
        return this.getRocketItem();
    }

    protected void spawnRocketItem() {
        ItemEntity entityToSpawn = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getRocketItem());
        entityToSpawn.m_32010_(10);
        this.f_19853_.m_7967_((Entity)entityToSpawn);
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().get();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
        compound.m_128379_("rocket_start", ((Boolean)this.m_20088_().m_135370_(ROCKET_START)).booleanValue());
        compound.m_128405_("fuel", ((Integer)this.m_20088_().m_135370_(FUEL)).intValue());
        compound.m_128405_("start_timer", ((Integer)this.m_20088_().m_135370_(START_TIMER)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            this.inventory.deserializeNBT((CompoundTag)inventoryCustom);
        }
        this.m_20088_().m_135381_(ROCKET_START, (Object)compound.m_128471_("rocket_start"));
        this.m_20088_().m_135381_(FUEL, (Object)compound.m_128451_("fuel"));
        this.m_20088_().m_135381_(START_TIMER, (Object)compound.m_128451_("start_timer"));
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        super.m_6096_(player, hand);
        InteractionResult result = InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        if (!this.f_19853_.f_46443_) {
            if (player.m_6047_()) {
                this.m_213583_(player);
                return InteractionResult.CONSUME;
            }
            player.m_20329_((Entity)this);
            return InteractionResult.CONSUME;
        }
        return result;
    }

    public void m_213583_(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return IRocketEntity.this.m_7755_();
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.m_130130_(IRocketEntity.this.m_19879_());
                    return new RocketMenu.GuiContainer(id, inventory, packetBuffer);
                }
            }, buf -> buf.m_130130_(this.m_19879_()));
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Vec3[] avector3d = new Vec3[]{IRocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)livingEntity.m_146908_()), IRocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() - 22.5f)), IRocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() + 22.5f)), IRocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() - 45.0f)), IRocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.m_20191_().f_82292_;
        double d1 = this.m_20191_().f_82289_ - 0.5;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Vec3 vector3d : avector3d) {
            blockpos$mutable.m_122169_(this.m_20185_() + vector3d.f_82479_, d0, this.m_20189_() + vector3d.f_82481_);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockpos$mutable.m_7949_());
                blockpos$mutable.m_122173_(Direction.DOWN);
            }
        }
        for (BlockPos blockpos : set) {
            double d3;
            if (this.f_19853_.m_6425_(blockpos).m_205070_(FluidTags.f_13132_) || !DismountHelper.m_38439_((double)(d3 = this.f_19853_.m_45573_(blockpos)))) continue;
            Vec3 vector3d1 = Vec3.m_82514_((Vec3i)blockpos, (double)d3);
            for (Pose pose : livingEntity.m_7431_()) {
                if (!DismountHelper.m_38439_((double)this.f_19853_.m_45573_(blockpos))) continue;
                livingEntity.m_20124_(pose);
                return vector3d1;
            }
        }
        return new Vec3(this.m_20185_(), this.m_20191_().f_82292_, this.m_20189_());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.rotateRocket();
        this.checkOnBlocks();
        this.fillUpRocket();
        this.rocketExplosion();
        this.burnEntities();
        if (((Boolean)this.f_19804_.m_135370_(ROCKET_START)).booleanValue()) {
            this.spawnParticle();
            this.startTimerAndFlyMovement();
            this.openPlanetSelectionMenu();
        }
    }

    public abstract void spawnParticle();

    public void fillUpRocket() {
        ItemStack slotItem0 = this.getInventory().getStackInSlot(0);
        ItemStack slotItem1 = this.getInventory().getStackInSlot(1);
        if (slotItem0.m_41720_() instanceof BucketItem && ((BucketItem)slotItem0.m_41720_()).getFluid().m_205067_(TagRegistry.FLUID_VEHICLE_FUEL_TAG) && (Integer)this.f_19804_.m_135370_(FUEL) + 1000 <= this.getFuelCapacity() && slotItem1.m_41613_() != slotItem1.m_41741_()) {
            this.getInventory().extractItem(0, 1, false);
            this.getInventory().insertItem(1, new ItemStack((ItemLike)Items.f_42446_), false);
            this.m_20088_().m_135381_(FUEL, (Object)((Integer)this.f_19804_.m_135370_(FUEL) + 1000));
        }
    }

    public Player getFirstPlayerPassenger() {
        Object e;
        if (!this.m_20197_().isEmpty() && (e = this.m_20197_().get(0)) instanceof Player) {
            Player player = (Player)e;
            return player;
        }
        return null;
    }

    public void rotateRocket() {
        Player player = this.getFirstPlayerPassenger();
        if (player != null) {
            if (KeyVariables.isHoldingRight(player) && KeyVariables.isHoldingLeft(player)) {
                return;
            }
            if (KeyVariables.isHoldingRight(player)) {
                Methods.setEntityRotation(this, 1.0f);
            }
            if (KeyVariables.isHoldingLeft(player)) {
                Methods.setEntityRotation(this, -1.0f);
            }
        }
    }

    public void startRocket() {
        Player player = this.getFirstPlayerPassenger();
        if (player != null) {
            SynchedEntityData data = this.m_20088_();
            if (((Integer)data.m_135370_(FUEL)).intValue() == this.getFuelCapacity()) {
                if (!((Boolean)data.m_135370_(ROCKET_START)).booleanValue()) {
                    data.m_135381_(ROCKET_START, (Object)true);
                    this.f_19853_.m_6269_(null, (Entity)this, (SoundEvent)SoundRegistry.ROCKET_SOUND.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else {
                Methods.sendVehicleHasNoFuelMessage(player);
            }
        }
    }

    public boolean doesDrop(BlockState state, BlockPos pos) {
        if (this.m_20096_() || this.isInFluidType()) {
            BlockState state2 = this.f_19853_.m_8055_(new BlockPos(Math.floor(this.m_20185_()), this.m_20186_() - 0.2, Math.floor(this.m_20189_())));
            if (!this.f_19853_.m_46859_(pos) && (state2.m_60734_() instanceof RocketLaunchPad && !((Boolean)state2.m_61143_((Property)RocketLaunchPad.STAGE)).booleanValue() || !(state.m_60734_() instanceof RocketLaunchPad))) {
                this.dropEquipment();
                this.spawnRocketItem();
                if (!this.f_19853_.f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                return true;
            }
        }
        return false;
    }

    protected void checkOnBlocks() {
        AABB aabb = this.m_20191_();
        BlockPos blockPos1 = new BlockPos(aabb.f_82288_ + 0.001, aabb.f_82289_ - 0.2 + 0.001, aabb.f_82290_ + 0.001);
        BlockPos blockPos2 = new BlockPos(aabb.f_82291_ - 0.001, aabb.f_82289_ - 0.001, aabb.f_82293_ - 0.001);
        if (this.f_19853_.m_46832_(blockPos1, blockPos2)) {
            for (int i = blockPos1.m_123341_(); i <= blockPos2.m_123341_(); ++i) {
                for (int j = blockPos1.m_123342_(); j <= blockPos2.m_123342_(); ++j) {
                    for (int k = blockPos1.m_123343_(); k <= blockPos2.m_123343_(); ++k) {
                        BlockPos pos = new BlockPos(i, j, k);
                        BlockState state = this.f_19853_.m_8055_(pos);
                        if (!this.doesDrop(state, pos)) continue;
                        return;
                    }
                }
            }
        }
    }

    public void startTimerAndFlyMovement() {
        if ((Integer)this.f_19804_.m_135370_(START_TIMER) < 200) {
            this.f_19804_.m_135381_(START_TIMER, (Object)((Integer)this.f_19804_.m_135370_(START_TIMER) + 1));
        }
        if ((Integer)this.f_19804_.m_135370_(START_TIMER) == 200) {
            if (this.m_20184_().f_82480_ < this.getRocketSpeed() - 0.1) {
                this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.1, this.m_20184_().f_82481_);
            } else {
                this.m_20334_(this.m_20184_().f_82479_, this.getRocketSpeed(), this.m_20184_().f_82481_);
            }
        }
    }

    public void openPlanetSelectionMenu() {
        Player player = this.getFirstPlayerPassenger();
        if (this.m_20186_() > 600.0) {
            if (player != null) {
                if (player.f_36096_ == player.f_36095_) {
                    player.m_6915_();
                }
                player.getPersistentData().m_128379_("beyond_earth:planet_selection_menu_open", true);
                player.getPersistentData().m_128405_("beyond_earth:rocket_tier", this.getTier());
                ListTag tag = new ListTag();
                tag.add((Object)new ItemStack((ItemLike)this.getRocketItem().m_41720_()).m_41739_(new CompoundTag()));
                for (int i = 0; i <= this.getInventory().getSlots() - 1; ++i) {
                    tag.add((Object)this.getInventory().getStackInSlot(i).m_41739_(new CompoundTag()));
                }
                player.getPersistentData().m_128365_("beyond_earth:rocket_item_list", (Tag)tag);
                player.m_20242_(true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Methods.stopSound(serverPlayer, SoundRegistry.ROCKET_SOUND.getId(), SoundSource.NEUTRAL);
                }
                MinecraftForge.EVENT_BUS.post((Event)new SetPlanetSelectionMenuNeededNbtEvent(player, this));
                if (!this.f_19853_.f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else if (!this.f_19853_.f_46443_) {
                this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20191_().f_82292_, this.m_20189_(), 10.0f, false, Explosion.BlockInteraction.BREAK);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void rocketExplosion() {
        if ((Integer)this.f_19804_.m_135370_(START_TIMER) == 200 && this.m_20184_().f_82480_ < -0.07 && !this.f_19853_.f_46443_) {
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20191_().f_82292_, this.m_20189_(), 10.0f, true, Explosion.BlockInteraction.BREAK);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void burnEntities() {
        if ((Integer)this.f_19804_.m_135370_(START_TIMER) == 200) {
            AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() - 2.0, this.m_20189_()), (double)2.0, (double)2.0, (double)2.0);
            List entities = this.m_20193_().m_45976_(LivingEntity.class, aabb);
            for (LivingEntity entity : entities) {
                if (Methods.isLivingInNetheriteSpaceSuit(entity) || Methods.isLivingInJetSuit(entity)) continue;
                entity.m_20254_(15);
            }
        }
    }
}

