/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.entities;

import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.mrscauthd.beyond_earth.common.entities.IVehicleEntity;
import net.mrscauthd.beyond_earth.common.keybinds.KeyVariables;
import net.mrscauthd.beyond_earth.common.menus.LanderMenu;

public class LanderEntity
extends IVehicleEntity {
    public static Consumer<LanderEntity> playBoost = e -> {};
    public static Consumer<LanderEntity> playBeep = e -> {};
    private final ItemStackHandler inventory = new ItemStackHandler(11){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory});

    public LanderEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public void m_7334_(Entity p_21294_) {
    }

    @Deprecated
    public boolean canBeRiddenInWater() {
        return true;
    }

    public boolean m_6146_() {
        return true;
    }

    public double m_6048_() {
        return super.m_6048_() - 0.25;
    }

    public void m_6074_() {
        this.dropEquipment();
        if (!this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!source.m_19360_() && source.m_7639_() != null && source.m_7639_().m_6047_() && !this.m_20160_()) {
            this.dropEquipment();
            if (!this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    public boolean m_142535_(float p_150347_, float p_150348_, DamageSource p_150349_) {
        if (p_150347_ >= 3.0f && !this.f_19853_.f_46443_) {
            this.f_19853_.m_46518_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0f, true, Explosion.BlockInteraction.BREAK);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return super.m_142535_(p_150347_, p_150348_, p_150349_);
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().get();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            this.inventory.deserializeNBT((CompoundTag)inventoryCustom);
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        super.m_6096_(player, hand);
        InteractionResult result = InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        if (!this.f_19853_.f_46443_) {
            if (player.m_6047_()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237115_((String)"container.entity.beyond_earth.lander");
                    }

                    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                        packetBuffer.m_130130_(LanderEntity.this.m_19879_());
                        return new LanderMenu.GuiContainer(id, inventory, packetBuffer);
                    }
                }, buf -> buf.m_130130_(this.m_19879_()));
                return InteractionResult.CONSUME;
            }
            player.m_20329_((Entity)this);
            return InteractionResult.CONSUME;
        }
        return result;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.slowDownLander();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.beepWarningSound();
        this.boostSound();
    }

    public void beepWarningSound() {
        if (this.f_19853_.m_5776_()) {
            playBeep.accept(this);
        }
    }

    public void boostSound() {
        if (this.f_19853_.m_5776_()) {
            playBoost.accept(this);
        }
    }

    public Player getFirstPlayerPassenger() {
        Object e;
        if (!this.m_20197_().isEmpty() && (e = this.m_20197_().get(0)) instanceof Player) {
            Player player = (Player)e;
            return player;
        }
        return null;
    }

    public void slowDownLander() {
        Player player = this.getFirstPlayerPassenger();
        if (player != null && KeyVariables.isHoldingJump(player)) {
            Vec3 vec = this.m_20184_();
            if (!this.m_20096_() && !this.m_204029_(FluidTags.f_13131_)) {
                if (vec.m_7098_() < -0.05) {
                    this.m_20334_(vec.m_7096_(), vec.m_7098_() * 0.85, vec.m_7094_());
                }
                this.f_19789_ = (float)(vec.m_7098_() * -1.0 * 4.5);
                if (this.f_19853_ instanceof ServerLevel) {
                    for (ServerPlayer p : ((ServerLevel)player.f_19853_).m_7654_().m_6846_().m_11314_()) {
                        ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ParticleTypes.f_123764_, true, this.m_20185_(), this.m_20186_() - 0.3, this.m_20189_(), 3, 0.1, 0.1, 0.1, 0.001);
                    }
                }
            }
        }
    }
}

