/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.entities;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.common.config.Config;
import net.mrscauthd.beyond_earth.common.entities.IRocketEntity;
import net.mrscauthd.beyond_earth.common.events.forge.SetRocketItemStackEvent;
import net.mrscauthd.beyond_earth.common.registries.ItemsRegistry;
import net.mrscauthd.beyond_earth.common.registries.ParticleRegistry;

public class RocketTier3Entity
extends IRocketEntity {
    public static final int DEFAULT_FUEL_BUCKETS = 3;

    public RocketTier3Entity(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Override
    public double getRocketSpeed() {
        return 0.8;
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public int getBucketsOfFull() {
        return (Integer)Config.ROCKET_TIER_3_FUEL_BUCKETS.get();
    }

    public double m_6048_() {
        return super.m_6048_() - 2.65;
    }

    @Override
    public ItemStack getRocketItem() {
        ItemStack itemStack = new ItemStack((ItemLike)ItemsRegistry.TIER_3_ROCKET_ITEM.get(), 1);
        itemStack.m_41784_().m_128405_("beyond_earth:fuel", ((Integer)this.m_20088_().m_135370_(FUEL)).intValue());
        MinecraftForge.EVENT_BUS.post((Event)new SetRocketItemStackEvent(this, itemStack));
        return itemStack;
    }

    @Override
    public void spawnParticle() {
        block4: {
            Vec3 vec = this.m_20184_();
            if (!(this.f_19853_ instanceof ServerLevel)) break block4;
            if ((Integer)this.f_19804_.m_135370_(START_TIMER) == 200) {
                for (ServerPlayer p : ((ServerLevel)this.f_19853_).m_7654_().m_6846_().m_11314_()) {
                    float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.90999997f;
                    float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.90999997f;
                    ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ParticleRegistry.LARGE_FLAME_PARTICLE.get(), true, this.m_20185_() - vec.f_82479_, this.m_20186_() - vec.f_82480_ - 2.6, this.m_20189_() - vec.f_82481_, 20, 0.1, 0.1, 0.1, 0.001);
                    ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ParticleRegistry.LARGE_SMOKE_PARTICLE.get(), true, this.m_20185_() - vec.f_82479_, this.m_20186_() - vec.f_82480_ - 3.6, this.m_20189_() - vec.f_82481_, 10, 0.1, 0.1, 0.1, 0.04);
                    ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ParticleRegistry.SMALL_FLAME_PARTICLE.get(), true, this.m_20185_() + (double)f2, this.m_20186_() - vec.f_82480_ - 2.5, this.m_20189_() + (double)f3, 20, 0.1, 0.1, 0.1, 0.001);
                    ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ParticleRegistry.SMALL_SMOKE_PARTICLE.get(), true, this.m_20185_() + (double)f2, this.m_20186_() - vec.f_82480_ - 3.5, this.m_20189_() + (double)f3, 10, 0.1, 0.1, 0.1, 0.04);
                    ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ParticleRegistry.SMALL_FLAME_PARTICLE.get(), true, this.m_20185_() - (double)f2, this.m_20186_() - vec.f_82480_ - 2.5, this.m_20189_() - (double)f3, 20, 0.1, 0.1, 0.1, 0.001);
                    ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ParticleRegistry.SMALL_SMOKE_PARTICLE.get(), true, this.m_20185_() - (double)f2, this.m_20186_() - vec.f_82480_ - 3.5, this.m_20189_() - (double)f3, 10, 0.1, 0.1, 0.1, 0.04);
                }
            } else {
                for (ServerPlayer p : ((ServerLevel)this.f_19853_).m_7654_().m_6846_().m_11314_()) {
                    ((ServerLevel)this.f_19853_).m_8624_(p, (ParticleOptions)ParticleTypes.f_123777_, true, this.m_20185_() - vec.f_82479_, this.m_20186_() - vec.f_82480_ - 0.1, this.m_20189_() - vec.f_82481_, 6, 0.1, 0.1, 0.1, 0.023);
                }
            }
        }
    }
}

