/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.items;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.mrscauthd.beyond_earth.client.registries.ItemRendererRegistry;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.common.blocks.entities.machines.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.common.config.Config;
import net.mrscauthd.beyond_earth.common.entities.RoverEntity;
import net.mrscauthd.beyond_earth.common.items.VehicleItem;
import net.mrscauthd.beyond_earth.common.registries.EntityRegistry;

public class RoverItem
extends VehicleItem {
    public static String FUEL_TAG = "beyond_earth:fuel";

    public RoverItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        int fuel = itemStack.m_41784_().m_128451_(FUEL_TAG);
        int capacity = (Integer)Config.ROVER_FUEL_BUCKETS.get() * 1000;
        list.add((Component)GaugeTextHelper.buildFuelStorageTooltip(GaugeValueHelper.getFuel(fuel, capacity), ChatFormatting.GRAY));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        if (world.m_5776_()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        ItemStack itemStack = context.m_43722_();
        Level level = context.m_43725_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockPlaceContext blockplacecontext = new BlockPlaceContext(context);
        BlockPos blockpos = blockplacecontext.m_8083_();
        Vec3 vec3 = Vec3.m_82539_((Vec3i)blockpos);
        AABB aabb = ((EntityType)EntityRegistry.ROVER.get()).m_20680_().m_20384_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
        if (level.m_45772_(aabb)) {
            AABB scanAbove = new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            List entities = player.m_20193_().m_45976_(Entity.class, scanAbove);
            if (entities.isEmpty()) {
                RoverEntity rover = new RoverEntity((EntityType)EntityRegistry.ROVER.get(), world);
                rover.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
                double d0 = RoverItem.getYOffset((LevelReader)world, pos, true, rover.m_20191_());
                float f = (float)Mth.m_14143_((float)((Mth.m_14177_((float)(context.m_7074_() - 180.0f)) + 5.626f) / 11.25f)) * 11.25f;
                rover.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + d0, (double)pos.m_123343_() + 0.5, f + 180.0f, 0.0f);
                rover.f_19859_ = rover.m_146908_();
                world.m_7967_((Entity)rover);
                rover.m_20088_().m_135381_(RoverEntity.FUEL, (Object)itemStack.m_41784_().m_128451_(FUEL_TAG));
                if (!player.m_150110_().f_35937_) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                } else {
                    player.m_21011_(context.m_43724_(), true);
                }
                RoverItem.roverPlaceSound(pos, world);
            }
        }
        return super.m_6225_(context);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ItemRendererRegistry.ROVER_ITEM_RENDERER;
            }
        });
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        super.m_6787_(p_41391_, p_41392_);
        if (this.m_220152_(p_41391_)) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            itemStack.m_41784_().m_128405_(FUEL_TAG, (Integer)Config.ROVER_FUEL_BUCKETS.get() * 1000);
            p_41392_.add((Object)itemStack);
        }
    }

    public static void roverPlaceSound(BlockPos pos, Level world) {
        world.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

