/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.jei.categories;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Constants;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.mrscauthd.beyond_earth.common.config.Config;
import net.mrscauthd.beyond_earth.common.data.recipes.GeneratingRecipe;
import net.mrscauthd.beyond_earth.common.jei.Jei;
import net.mrscauthd.beyond_earth.common.jei.helper.EnergyIngredient;
import net.mrscauthd.beyond_earth.common.registries.ItemsRegistry;

public class CoalGenerator
implements IRecipeCategory<GeneratingRecipe> {
    public static final ResourceLocation GUI = new ResourceLocation("beyond_earth", "textures/jei/jei_gui_1.png");
    public static final int width = 128;
    public static final int height = 64;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    final IGuiHelper guiHelper;
    private final LoadingCache<Integer, IDrawableAnimated> cachedFlames;

    public CoalGenerator(final IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.background = guiHelper.createDrawable(GUI, 0, 0, 128, 64);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemsRegistry.COAL_GENERATOR_ITEM.get()));
        this.localizedName = I18n.m_118938_((String)"container.beyond_earth.coal_generator", (Object[])new Object[0]);
        this.cachedFlames = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer burnTime) {
                return guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 82, 114, 14, 14).buildAnimated(burnTime.intValue(), IDrawableAnimated.StartDirection.TOP, true);
            }
        });
    }

    public RecipeType<GeneratingRecipe> getRecipeType() {
        return Jei.COAL_TYPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)this.localizedName);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public List<Component> getTooltipStrings(GeneratingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void draw(GeneratingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        int burnTime = recipe.getBurnTime();
        IDrawableAnimated flame = (IDrawableAnimated)this.cachedFlames.getUnchecked((Object)burnTime);
        flame.draw(stack, 31, 39);
        ((IRecipeSlotView)recipeSlotsView.getSlotViews(RecipeIngredientRole.OUTPUT).get(0)).getIngredients(Jei.FE_INGREDIENT_TYPE).forEach(i -> i.setAmount((Integer)Config.COAL_GENERATOR_ENERGY_GENERATION.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GeneratingRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputStack = builder.addSlot(RecipeIngredientRole.INPUT, 30, 19);
        inputStack.addIngredients(recipe.getInput());
        IRecipeSlotBuilder outputStack = builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 9);
        outputStack.addIngredient(Jei.FE_INGREDIENT_TYPE, (Object)EnergyIngredient.OUTTANK);
        outputStack.setCustomRenderer(Jei.FE_INGREDIENT_TYPE, (IIngredientRenderer)EnergyIngredient.OUTTANK);
    }
}

