/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.jei.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.mrscauthd.beyond_earth.common.jei.helper.DrawableFluidAnimated;

public class CustomFluidRenderer
implements IIngredientRenderer<FluidStack> {
    private final LoadingCache<Integer, DrawableFluidAnimated> cachedTank;
    final boolean inTank;

    public CustomFluidRenderer(final boolean inTank, final boolean O2) {
        this.inTank = inTank;
        this.cachedTank = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, DrawableFluidAnimated>(){

            public DrawableFluidAnimated load(Integer stack) {
                return new DrawableFluidAnimated(100 * stack, inTank, FluidStack.EMPTY, O2);
            }
        });
    }

    public CustomFluidRenderer(boolean inTank) {
        this(inTank, false);
    }

    public void render(PoseStack stack, FluidStack ingredient) {
        DrawableFluidAnimated fluid = (DrawableFluidAnimated)this.cachedTank.getUnchecked((Object)ingredient.getAmount());
        fluid.setFluid(ingredient);
        fluid.draw(stack);
    }

    public List<Component> getTooltip(FluidStack ingredient, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Fluid fluidType = ingredient.getFluid();
        try {
            if (fluidType.m_6212_(Fluids.f_76191_)) {
                return tooltip;
            }
            Component displayName = ingredient.getDisplayName();
            tooltip.add(displayName);
            long amount = ingredient.getAmount();
            long milliBuckets = amount * 1000L / 1000L;
            NumberFormat nf = NumberFormat.getIntegerInstance();
            MutableComponent amountString = Component.m_237110_((String)"jei.tooltip.liquid.amount", (Object[])new Object[]{nf.format(milliBuckets)});
            tooltip.add((Component)amountString.m_130940_(ChatFormatting.GRAY));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return tooltip;
    }

    public int getWidth() {
        return 12;
    }

    public int getHeight() {
        return 46;
    }
}

