/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.jei.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import net.mrscauthd.beyond_earth.common.jei.Jei;
import net.mrscauthd.beyond_earth.common.jei.helper.DrawableEnergyAnimated;
import org.jetbrains.annotations.Nullable;

public class EnergyIngredient
implements IIngredientHelper<EnergyIngredient>,
IIngredientRenderer<EnergyIngredient> {
    public static final EnergyIngredient INSTANCE = new EnergyIngredient();
    public static final EnergyIngredient INTANK = new EnergyIngredient();
    public static final EnergyIngredient OUTTANK = new EnergyIngredient();
    static final List<EnergyIngredient> ALL = Lists.newArrayList((Object[])new EnergyIngredient[]{INTANK, OUTTANK});
    private final LoadingCache<Integer, DrawableEnergyAnimated> cachedTank = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, DrawableEnergyAnimated>(){

        public DrawableEnergyAnimated load(Integer stack) {
            return new DrawableEnergyAnimated(100 * stack, EnergyIngredient.this == INTANK);
        }
    });
    private int amount = 0;

    public static Collection<EnergyIngredient> getIngredients() {
        return ALL;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void render(PoseStack stack, EnergyIngredient ingredient) {
        int amount = Math.max(ingredient.amount, 1);
        DrawableEnergyAnimated fluid = (DrawableEnergyAnimated)this.cachedTank.getUnchecked((Object)amount);
        fluid.draw(stack);
    }

    public List<Component> getTooltip(EnergyIngredient ingredient, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        try {
            String displayName = this.getDisplayName(ingredient);
            tooltip.add((Component)Component.m_237113_((String)displayName));
            long l = ingredient.amount;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return tooltip;
    }

    public int getWidth() {
        return 13;
    }

    public int getHeight() {
        return 46;
    }

    public IIngredientType<EnergyIngredient> getIngredientType() {
        return Jei.FE_INGREDIENT_TYPE;
    }

    public String getDisplayName(EnergyIngredient ingredient) {
        return I18n.m_118938_((String)"general.beyond_earth.energy", (Object[])new Object[0]);
    }

    public String getUniqueId(EnergyIngredient ingredient, UidContext context) {
        return "beyond_earth:energy";
    }

    public ResourceLocation getResourceLocation(EnergyIngredient ingredient) {
        return new ResourceLocation("beyond_earth:energy");
    }

    public EnergyIngredient copyIngredient(EnergyIngredient ingredient) {
        return ingredient;
    }

    public String getErrorInfo(@Nullable EnergyIngredient ingredient) {
        return "error with energy?";
    }

    public static final class DummyRenderer
    implements IIngredientRenderer<EnergyIngredient> {
        public void render(PoseStack stack, EnergyIngredient ingredient) {
        }

        public List<Component> getTooltip(EnergyIngredient ingredient, TooltipFlag tooltipFlag) {
            return Lists.newArrayList();
        }
    }
}

