/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.menus.helper;

import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class MenuHelper {
    public static void createInventorySlots(Inventory inventory, Function<Slot, Slot> slotCreator, int left, int top) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                slotCreator.apply(new Slot((Container)inventory, l + k * 9 + 9, left + l * 18, top + k * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            slotCreator.apply(new Slot((Container)inventory, i1, left + i1 * 18, top + 58));
        }
    }

    public static boolean isEmpty(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static NonNullList<ItemStack> getStacks(IItemHandler handler) {
        NonNullList list = NonNullList.m_122780_((int)handler.getSlots(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            list.set(i, (Object)stack);
        }
        return list;
    }

    public static ItemStack transferStackInSlot(AbstractContainerMenu container, Player player, int slotNumber, int containerIndex, int containerSize, MenuTransfer mergeItemStack) {
        ItemStack itemStack = ItemStack.f_41583_;
        NonNullList inventorySlots = container.f_38839_;
        Slot slot = (Slot)inventorySlots.get(slotNumber);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            int playerInventoryStartIndex = containerIndex + containerSize;
            if (slotNumber < playerInventoryStartIndex ? !mergeItemStack.moveItemStackTo(slotStack, playerInventoryStartIndex, inventorySlots.size(), true) : !mergeItemStack.moveItemStackTo(slotStack, containerIndex, playerInventoryStartIndex, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemStack;
    }

    public static ItemStack transferStackInSlot(AbstractContainerMenu container, Player player, int slotNumber, int containerIndex, Container inventory, MenuTransfer mergeItemStack) {
        int containerSize = inventory.m_6643_();
        return MenuHelper.transferStackInSlot(container, player, slotNumber, containerIndex, containerSize, mergeItemStack);
    }

    public static ItemStack transferStackInSlot(AbstractContainerMenu container, Player player, int slotNumber, Container inventory, MenuTransfer mergeItemStack) {
        return MenuHelper.transferStackInSlot(container, player, slotNumber, 0, inventory, mergeItemStack);
    }

    public static interface MenuTransfer {
        public boolean moveItemStackTo(ItemStack var1, int var2, int var3, boolean var4);
    }
}

