/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.registries;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.mrscauthd.beyond_earth.common.data.PlanetData;
import net.mrscauthd.beyond_earth.common.keybinds.KeyHandler;
import net.mrscauthd.beyond_earth.common.menus.planetselection.PlanetSelectionMenuNetworkHandler;

public class NetworkRegistry {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = net.minecraftforge.network.NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("beyond_earth", "beyond_earth"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID;

    public static void register() {
        NetworkRegistry.addNetworkMessage(PlanetSelectionMenuNetworkHandler.class, PlanetSelectionMenuNetworkHandler::encode, PlanetSelectionMenuNetworkHandler::decode, PlanetSelectionMenuNetworkHandler::handle);
        NetworkRegistry.addNetworkMessage(KeyHandler.class, KeyHandler::encode, KeyHandler::decode, KeyHandler::handle);
        NetworkRegistry.addNetworkMessage(PlanetData.PlanetDataHandler.class, PlanetData.PlanetDataHandler::encode, PlanetData.PlanetDataHandler::decode, PlanetData.PlanetDataHandler::handle);
    }

    private static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }
}

