/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.registries;

import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.mrscauthd.beyond_earth.common.registries.LevelRegistry;
import net.mrscauthd.beyond_earth.common.util.Planets;

public class PlanetRegistry {
    private static final ResourceLocation MOON_PLANET_BAR = new ResourceLocation("beyond_earth", "textures/planet_bar/moon_planet_bar.png");
    private static final ResourceLocation MARS_PLANET_BAR = new ResourceLocation("beyond_earth", "textures/planet_bar/mars_planet_bar.png");
    private static final ResourceLocation MERCURY_PLANET_BAR = new ResourceLocation("beyond_earth", "textures/planet_bar/mercury_planet_bar.png");
    private static final ResourceLocation VENUS_PLANET_BAR = new ResourceLocation("beyond_earth", "textures/planet_bar/venus_planet_bar.png");
    private static final ResourceLocation GLACIO_PLANET_BAR = new ResourceLocation("beyond_earth", "textures/planet_bar/glacio_planet_bar.png");
    private static final ResourceLocation SUN_TEXTURE = new ResourceLocation("beyond_earth", "textures/environment/planet/sun.png");
    private static final ResourceLocation MARS_TEXTURE = new ResourceLocation("beyond_earth", "textures/environment/planet/mars.png");
    private static final ResourceLocation PHOBOS_TEXTURE = new ResourceLocation("beyond_earth", "textures/environment/planet/phobos.png");
    private static final ResourceLocation DEIMOS_TEXTURE = new ResourceLocation("beyond_earth", "textures/environment/planet/deimos.png");
    private static final ResourceLocation EARTH_TEXTURE = new ResourceLocation("beyond_earth", "textures/environment/planet/earth.png");
    private static final ResourceLocation MOON_TEXTURE = new ResourceLocation("beyond_earth", "textures/environment/planet/moon.png");
    private static final ResourceLocation VENUS_TEXTURE = new ResourceLocation("beyond_earth", "textures/environment/planet/venus.png");
    private static final ResourceLocation MERCURY_TEXTURE = new ResourceLocation("beyond_earth", "textures/environment/planet/mercury.png");
    private static final ResourceLocation GLACIO_TEXTURE = new ResourceLocation("beyond_earth", "textures/environment/planet/glacio.png");

    public static void registerDefaultPlanets() {
        Planets.registerPlanet((ResourceKey<Level>)Level.f_46428_, LevelRegistry.EARTH_ORBIT);
        Planets.registerPlanet(LevelRegistry.MOON, LevelRegistry.MOON_ORBIT);
        Planets.registerPlanet(LevelRegistry.MARS, LevelRegistry.MARS_ORBIT);
        Planets.registerPlanet(LevelRegistry.PHOBOS, LevelRegistry.PHOBOS_ORBIT);
        Planets.registerPlanet(LevelRegistry.DEIMOS, LevelRegistry.DEIMOS_ORBIT);
        Planets.registerPlanet(LevelRegistry.MERCURY, LevelRegistry.MERCURY_ORBIT);
        Planets.registerPlanet(LevelRegistry.VENUS, LevelRegistry.VENUS_ORBIT);
        Planets.registerPlanet(LevelRegistry.GLACIO, LevelRegistry.GLACIO_ORBIT);
        Planets.registerPlanetBar(LevelRegistry.MOON, MOON_PLANET_BAR);
        Planets.registerPlanetBar(LevelRegistry.PHOBOS, MOON_PLANET_BAR);
        Planets.registerPlanetBar(LevelRegistry.DEIMOS, MOON_PLANET_BAR);
        Planets.registerPlanetBar(LevelRegistry.MARS, MARS_PLANET_BAR);
        Planets.registerPlanetBar(LevelRegistry.MERCURY, MERCURY_PLANET_BAR);
        Planets.registerPlanetBar(LevelRegistry.VENUS, VENUS_PLANET_BAR);
        Planets.registerPlanetBar(LevelRegistry.GLACIO, GLACIO_PLANET_BAR);
        Planets.StarSystem sol = new Planets.StarSystem();
        sol.name = "sun";
        sol.texture = SUN_TEXTURE;
        Planets.Planet mercury = Planets.BY_DIMENSION.get(LevelRegistry.MERCURY);
        mercury.orbitRadius = 5.8343224E7;
        mercury.mass = 3.24499998241663E23;
        mercury.texture = MERCURY_TEXTURE;
        mercury.rotation = 270.0f;
        mercury.tier = 3;
        mercury.g = 0.38f;
        mercury.radius = 2439.7;
        mercury.temperature = 430.0f;
        mercury.orbitColour = new int[]{179, 49, 44};
        Planets.Planet venus = Planets.BY_DIMENSION.get(LevelRegistry.VENUS);
        venus.orbitRadius = 1.07710576E8;
        venus.mass = 4.779000014066696E24;
        venus.texture = VENUS_TEXTURE;
        venus.rotation = 180.0f;
        venus.tier = 3;
        venus.g = 0.904f;
        venus.radius = 6051.8;
        venus.temperature = 482.0f;
        venus.airDensity = 100.0f;
        venus.orbitColour = new int[]{235, 136, 68};
        Planets.Planet earth = Planets.BY_DIMENSION.get(LevelRegistry.EARTH);
        earth.texture = EARTH_TEXTURE;
        earth.rotation = 90.0f;
        earth.tier = 1;
        earth.radius = 6371.0;
        earth.airDensity = 1.0f;
        earth.hasOxygen = true;
        earth.spaceLevel = false;
        earth.hasRain = true;
        earth.orbitColour = new int[]{53, 163, 79};
        Planets.Planet mars = Planets.BY_DIMENSION.get(LevelRegistry.MARS);
        mars.orbitRadius = 2.27388976E8;
        mars.mass = 6.313000045716762E23;
        mars.texture = MARS_TEXTURE;
        mars.tier = 2;
        mars.radius = 3389.5;
        mars.g = 0.3794f;
        mars.temperature = -63.0f;
        mars.airDensity = 0.001f;
        mars.hasRain = true;
        mars.hasDustStorms = true;
        mars.orbitColour = new int[]{37, 49, 146};
        mars.sunriseColour = new float[]{0.0f, 0.55f, 0.8f};
        Planets.Planet phobos = Planets.BY_DIMENSION.get(LevelRegistry.PHOBOS);
        phobos.g = 0.04f;
        phobos.radius = 11.2;
        phobos.mass = 1.06E16;
        phobos.rotation = 180.0f;
        phobos.temperature = -160.0f;
        phobos.texture = PHOBOS_TEXTURE;
        phobos.orbitRadius = 9379.3349609375;
        phobos.orbitColour = mars.orbitColour;
        phobos.tidalLock = true;
        mars.addChild(phobos);
        Planets.Planet deimos = Planets.BY_DIMENSION.get(LevelRegistry.DEIMOS);
        deimos.g = 0.04f;
        deimos.radius = 6.2;
        deimos.mass = 1.476E15;
        deimos.temperature = -160.0f;
        deimos.texture = DEIMOS_TEXTURE;
        deimos.orbitRadius = 23448.33984375;
        deimos.orbitColour = mars.orbitColour;
        deimos.tidalLock = true;
        mars.addChild(deimos);
        Planets.Planet moon = Planets.BY_DIMENSION.get(LevelRegistry.MOON);
        moon.g = 0.1654f;
        moon.radius = 1737.4;
        moon.mass = 7.34E22;
        moon.temperature = -160.0f;
        moon.texture = MOON_TEXTURE;
        moon.orbitRadius = 384399.0;
        moon.orbitColour = earth.orbitColour;
        moon.tidalLock = true;
        moon.phaseTexture = new ResourceLocation("beyond_earth", "textures/environment/planet/moon_phases.png");
        earth.addChild(moon);
        sol.addChild(mercury);
        sol.addChild(venus);
        sol.addChild(earth);
        sol.addChild(mars);
        sol.register();
        Planets.StarSystem proxima_centauri = new Planets.StarSystem();
        proxima_centauri.name = "proxima_centauri";
        proxima_centauri.location[0] = 4.25f;
        proxima_centauri.mass = 2.4400000274181366E29;
        proxima_centauri.colour = new int[]{255, 127, 63};
        Planets.Planet glacio = Planets.BY_DIMENSION.get(LevelRegistry.GLACIO);
        glacio.texture = GLACIO_TEXTURE;
        glacio.mass = 4.7199998944997784E23;
        glacio.orbitRadius = 5.8343224E7;
        glacio.rotation = 180.0f;
        glacio.tier = 4;
        glacio.g = 0.3794f;
        glacio.temperature = -20.0f;
        glacio.hasRain = true;
        glacio.orbitColour = new int[]{37, 49, 146};
        proxima_centauri.addChild(glacio);
        proxima_centauri.register();
    }
}

