/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.common.events.forge.LivingGravityEvent;
import net.mrscauthd.beyond_earth.common.util.Planets;

public class EntityGravity {
    public static final UUID ARTIFICIAL_GRAVITY_ID = UUID.fromString("242A6B8D-DA4E-4C3C-1234-96EA6096568D");
    private static final Map<ResourceKey<Level>, List<GravitySource>> GRAVMAP = Maps.newConcurrentMap();
    public static final String TAG = "beyond_earth:space_gravity";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGravitySource(Level level, GravitySource g) {
        List sources;
        List list = sources = GRAVMAP.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new ArrayList());
        synchronized (list) {
            sources.add(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeGravitySource(Level level, GravitySource g) {
        List sources;
        List list = sources = GRAVMAP.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new ArrayList());
        synchronized (list) {
            sources.removeIf(g2 -> g2.centre().equals((Object)g.centre()));
        }
    }

    public static float getArtificalGravityModifier(Level level, BlockPos pos) {
        List sources = GRAVMAP.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new ArrayList());
        float g = 0.0f;
        for (GravitySource s : sources) {
            if (!(s.centre().m_123331_((Vec3i)pos) < (double)(s.range * s.range))) continue;
            g += s.gravity;
        }
        return g;
    }

    public static void setGravities(LivingEntity entity, Level level) {
        Attribute attribute = (Attribute)ForgeMod.ENTITY_GRAVITY.get();
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (entity.getPersistentData().m_128471_(TAG)) {
            EntityGravity.setGravity(entity, attributeInstance, attribute.m_22082_(), false);
        }
        if (!entity.getPersistentData().m_128471_(TAG)) {
            float entityGravity = Planets.getEntityGravityForLocation(level);
            if (entityGravity != -1.0f) {
                EntityGravity.setGravity(entity, attributeInstance, entityGravity, true);
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new LivingGravityEvent(entity, attribute, attributeInstance));
            }
        }
    }

    public static void setGravity(LivingEntity entity, AttributeInstance attributeInstance, double gravity, boolean condition) {
        attributeInstance.m_22100_(gravity);
        entity.getPersistentData().m_128379_(TAG, condition);
    }

    public record GravitySource(BlockPos centre, float gravity, int range) {
    }

    public static class GravityModifier
    extends AttributeInstance {
        public GravityModifier(Attribute attribute, Consumer<AttributeInstance> onDirty) {
            super(attribute, onDirty);
        }
    }
}

