/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.util;

import io.netty.buffer.Unpooled;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.BeyondEarth;
import net.mrscauthd.beyond_earth.common.armors.JetSuit;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.ChunkOxygen;
import net.mrscauthd.beyond_earth.common.entities.IRocketEntity;
import net.mrscauthd.beyond_earth.common.entities.IVehicleEntity;
import net.mrscauthd.beyond_earth.common.entities.LanderEntity;
import net.mrscauthd.beyond_earth.common.events.forge.LivingSetFireInHotPlanetEvent;
import net.mrscauthd.beyond_earth.common.events.forge.LivingSetVenusRainEvent;
import net.mrscauthd.beyond_earth.common.events.forge.ResetPlanetSelectionMenuNeededNbtEvent;
import net.mrscauthd.beyond_earth.common.events.forge.TeleportAndCreateLanderEvent;
import net.mrscauthd.beyond_earth.common.items.VehicleItem;
import net.mrscauthd.beyond_earth.common.menus.planetselection.PlanetSelectionMenu;
import net.mrscauthd.beyond_earth.common.registries.DamageSourceRegistry;
import net.mrscauthd.beyond_earth.common.registries.EntityRegistry;
import net.mrscauthd.beyond_earth.common.registries.ItemsRegistry;
import net.mrscauthd.beyond_earth.common.registries.TagRegistry;
import net.mrscauthd.beyond_earth.common.util.OxygenSystem;
import net.mrscauthd.beyond_earth.common.util.Planets;

public class Methods {
    public static final ResourceLocation SPACE_STATION = new ResourceLocation("beyond_earth", "space_station");
    public static final TagKey<Item> SPACE_SUIT_PART = TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.ITEMS, (ResourceLocation)new ResourceLocation("beyond_earth", "space_suit"));

    public static Entity teleportTo(Entity entity, ResourceKey<Level> levelKey, final double yPos) {
        if (!Methods.isLevel(entity.f_19853_, levelKey)) {
            if (entity.m_6072_()) {
                if (entity.m_20194_() == null) {
                    return entity;
                }
                ServerLevel nextLevel = entity.m_20194_().m_129880_(levelKey);
                if (nextLevel == null) {
                    BeyondEarth.LOGGER.error(levelKey.m_211136_() + " not existing!");
                    return entity;
                }
                return entity.changeDimension(nextLevel, new ITeleporter(){

                    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                        Vec3 pos = new Vec3(entity.m_20182_().f_82479_, yPos, entity.m_20182_().f_82481_);
                        return new PortalInfo(pos, Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
                    }

                    public boolean isVanilla() {
                        return false;
                    }

                    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
                        return false;
                    }
                });
            }
        } else {
            entity.m_6021_(entity.m_20185_(), yPos, entity.m_20189_());
            return entity;
        }
        return entity;
    }

    public static boolean isLivingInSpaceSuit(LivingEntity entity) {
        if (!Methods.isLivingInArmor(entity, EquipmentSlot.HEAD, (Item)ItemsRegistry.SPACE_HELMET.get())) {
            return false;
        }
        if (!Methods.isLivingInArmor(entity, EquipmentSlot.CHEST, (Item)ItemsRegistry.SPACE_SUIT.get())) {
            return false;
        }
        if (!Methods.isLivingInArmor(entity, EquipmentSlot.LEGS, (Item)ItemsRegistry.SPACE_PANTS.get())) {
            return false;
        }
        return Methods.isLivingInArmor(entity, EquipmentSlot.FEET, (Item)ItemsRegistry.SPACE_BOOTS.get());
    }

    public static boolean isLivingInNetheriteSpaceSuit(LivingEntity entity) {
        if (!Methods.isLivingInArmor(entity, EquipmentSlot.HEAD, (Item)ItemsRegistry.NETHERITE_SPACE_HELMET.get())) {
            return false;
        }
        if (!Methods.isLivingInArmor(entity, EquipmentSlot.CHEST, (Item)ItemsRegistry.NETHERITE_SPACE_SUIT.get())) {
            return false;
        }
        if (!Methods.isLivingInArmor(entity, EquipmentSlot.LEGS, (Item)ItemsRegistry.NETHERITE_SPACE_PANTS.get())) {
            return false;
        }
        return Methods.isLivingInArmor(entity, EquipmentSlot.FEET, (Item)ItemsRegistry.NETHERITE_SPACE_BOOTS.get());
    }

    public static boolean isLivingInJetSuit(LivingEntity entity) {
        if (!Methods.isLivingInArmor(entity, EquipmentSlot.HEAD, (Item)ItemsRegistry.JET_HELMET.get())) {
            return false;
        }
        if (!Methods.isLivingInArmor(entity, EquipmentSlot.CHEST, (Item)ItemsRegistry.JET_SUIT.get())) {
            return false;
        }
        if (!Methods.isLivingInArmor(entity, EquipmentSlot.LEGS, (Item)ItemsRegistry.JET_PANTS.get())) {
            return false;
        }
        return Methods.isLivingInArmor(entity, EquipmentSlot.FEET, (Item)ItemsRegistry.JET_BOOTS.get());
    }

    public static boolean isLivingInAnySpaceSuits(LivingEntity entity) {
        if (!entity.m_6844_(EquipmentSlot.HEAD).m_204117_(SPACE_SUIT_PART)) {
            return false;
        }
        if (!entity.m_6844_(EquipmentSlot.CHEST).m_204117_(SPACE_SUIT_PART)) {
            return false;
        }
        if (!entity.m_6844_(EquipmentSlot.LEGS).m_204117_(SPACE_SUIT_PART)) {
            return false;
        }
        return entity.m_6844_(EquipmentSlot.FEET).m_204117_(SPACE_SUIT_PART);
    }

    public static boolean isLivingInArmor(LivingEntity entity, EquipmentSlot slot, Item item) {
        return entity.m_6844_(slot).m_41720_() == item;
    }

    public static boolean isSpaceLevel(Level level) {
        return Planets.SPACE_LEVELS.contains(level.m_46472_());
    }

    public static boolean isSpaceLevelWithoutOxygen(Level level) {
        return Planets.LEVELS_WITHOUT_OXYGEN.contains(level.m_46472_());
    }

    public static boolean isOrbitLevel(Level level) {
        return Planets.PLANETS_BY_ORBIT.containsKey(level.m_46472_());
    }

    public static boolean isLevel(Level level, ResourceKey<Level> loc) {
        return level.m_46472_() == loc;
    }

    public static void hurtLivingWithOxygenSource(LivingEntity entity) {
        entity.m_6469_(DamageSourceRegistry.DAMAGE_SOURCE_OXYGEN, 1.0f);
    }

    public static void hurtLivingWithAcidRainSource(LivingEntity entity) {
        entity.m_6469_(DamageSourceRegistry.DAMAGE_SOURCE_ACID_RAIN, 1.0f);
    }

    public static boolean isRocket(Entity entity) {
        return entity instanceof IRocketEntity;
    }

    public static boolean isVehicle(Entity entity) {
        return entity instanceof IVehicleEntity;
    }

    public static boolean isVehicleItem(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof VehicleItem;
    }

    public static void dropOffHandVehicle(LivingEntity livingEntity) {
        ItemStack itemStack1 = livingEntity.m_21205_();
        ItemStack itemStack2 = livingEntity.m_21206_();
        if (Methods.isVehicleItem(itemStack1) && Methods.isVehicleItem(itemStack2)) {
            if (!livingEntity.f_19853_.f_46443_) {
                double d0 = livingEntity.m_20188_() - 0.3;
                ItemEntity itementity = new ItemEntity(livingEntity.f_19853_, livingEntity.m_20185_(), d0, livingEntity.m_20189_(), itemStack2.m_41777_());
                itementity.m_32010_(0);
                livingEntity.f_19853_.m_7967_((Entity)itementity);
            }
            itemStack2.m_41774_(1);
        }
    }

    public static void planetFire(LivingEntity entity, ResourceKey<Level> planet) {
        Player player;
        Level level = entity.f_19853_;
        if (!Methods.isLevel(level, planet)) {
            return;
        }
        if ((entity instanceof Mob || entity instanceof Player) && (Methods.isLivingInNetheriteSpaceSuit(entity) || Methods.isLivingInJetSuit(entity) || entity.m_21023_(MobEffects.f_19607_) || entity.m_5825_())) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_5833_() || player.m_150110_().f_35937_)) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingSetFireInHotPlanetEvent(entity, planet))) {
            return;
        }
        if (entity.m_6095_().m_204039_(TagRegistry.ENTITY_PLANET_FIRE_TAG)) {
            return;
        }
        if (ChunkOxygen.isBreatheable(OxygenSystem.canBreatheWithoutSuit(entity, false).O2())) {
            return;
        }
        entity.m_20254_(10);
    }

    public static void venusRain(LivingEntity entity, ResourceKey<Level> planet) {
        Player player;
        if (!Methods.isLevel(entity.f_19853_, planet)) {
            return;
        }
        if (entity.m_20159_() && (Methods.isRocket(entity.m_20202_()) || entity.m_20202_() instanceof LanderEntity)) {
            return;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_5833_() || player.m_150110_().f_35937_)) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingSetVenusRainEvent(entity, planet))) {
            return;
        }
        if (entity.m_6095_().m_204039_(TagRegistry.ENTITY_VENUS_RAIN_TAG)) {
            return;
        }
        if (entity.f_19853_.m_6106_().m_6533_() && (double)entity.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)Math.floor(entity.m_20185_()), (int)Math.floor(entity.m_20189_())) <= Math.floor(entity.m_20186_()) + 1.0 && !entity.f_19853_.f_46443_) {
            Methods.hurtLivingWithAcidRainSource(entity);
        }
    }

    public static void setJetSuitHoverPose(Player player) {
        ItemStack itemStack;
        if (!(!Methods.isLivingInJetSuit((LivingEntity)player) || (itemStack = player.m_6844_(EquipmentSlot.CHEST)).m_41784_().m_128451_("beyond_earth:jet_suit_mode") != JetSuit.Suit.ModeType.HOVER.getMode() || !player.m_6144_() || player.m_20096_() || player.m_21023_(MobEffects.f_19591_) || player.m_150110_().f_35935_ || player.m_5803_() || player.m_6069_() || player.m_21209_() || player.m_5833_() || player.m_20159_())) {
            player.m_20124_(Pose.STANDING);
        }
    }

    public static void setEntityRotation(Entity vehicle, float rotation) {
        vehicle.m_146922_(vehicle.m_146908_() + rotation);
        vehicle.m_5618_(vehicle.m_146908_());
        vehicle.f_19859_ = vehicle.m_146908_();
    }

    public static void teleportWithEntityTo(Entity entity, Entity vehicle, ResourceKey<Level> levelKey, int yPos) {
        Vec3 vec3 = entity.m_20182_();
        entity.m_142098_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        Entity newEntity = Methods.teleportTo(entity, levelKey, yPos);
        Entity newVehicle = Methods.teleportTo(vehicle, levelKey, yPos);
        newEntity.m_20329_(newVehicle);
    }

    public static void createLanderAndTeleportTo(ServerPlayer serverPlayer, ResourceKey<Level> levelKey, int yPos, boolean placeSpaceStation) {
        Methods.teleportTo((Entity)serverPlayer, levelKey, yPos);
        Level newLevel = serverPlayer.f_19853_;
        if (!newLevel.f_46443_) {
            LanderEntity landerEntity = new LanderEntity((EntityType)EntityRegistry.LANDER.get(), newLevel);
            landerEntity.m_20219_(serverPlayer.m_20182_());
            CompoundTag playerTag = serverPlayer.getPersistentData();
            for (int i = 0; i <= landerEntity.getInventory().getSlots() - 1; ++i) {
                CompoundTag compoundTag = playerTag.m_128437_("beyond_earth:rocket_item_list", 10).m_128728_(i);
                if (compoundTag.m_128456_()) continue;
                landerEntity.getInventory().setStackInSlot(i, ItemStack.m_41712_((CompoundTag)compoundTag));
            }
            newLevel.m_7967_((Entity)landerEntity);
            if (placeSpaceStation) {
                Methods.placeSpaceStation((Player)serverPlayer, (ServerLevel)newLevel);
            }
            MinecraftForge.EVENT_BUS.post((Event)new TeleportAndCreateLanderEvent(landerEntity, (Player)serverPlayer));
            Methods.resetPlanetSelectionMenuNeededNbt((Player)serverPlayer);
            serverPlayer.m_20329_((Entity)landerEntity);
        }
    }

    public static void placeSpaceStation(Player player, ServerLevel serverLevel) {
        StructureTemplate structureTemplate = serverLevel.m_215082_().m_230359_(SPACE_STATION);
        BlockPos pos = new BlockPos(player.m_20185_() - (double)(structureTemplate.m_163801_().m_123341_() / 2), 100.0, player.m_20189_() - (double)(structureTemplate.m_163801_().m_123343_() / 2));
        structureTemplate.m_230328_((ServerLevelAccessor)serverLevel, pos, pos, new StructurePlaceSettings(), serverLevel.f_46441_, 2);
    }

    public static void resetPlanetSelectionMenuNeededNbt(Player player) {
        player.getPersistentData().m_128379_("beyond_earth:planet_selection_menu_open", false);
        player.getPersistentData().m_128405_("beyond_earth:rocket_tier", 0);
        player.getPersistentData().m_128365_("beyond_earth:rocket_item_list", (Tag)new CompoundTag());
        MinecraftForge.EVENT_BUS.post((Event)new ResetPlanetSelectionMenuNeededNbtEvent(player));
    }

    public static void openPlanetGui(Player player) {
        if (!(player.f_36096_ instanceof PlanetSelectionMenu.GuiContainer) && player.getPersistentData().m_128471_("beyond_earth:planet_selection_menu_open") && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237113_((String)"Planet Selection");
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeInt(player.getPersistentData().m_128451_("beyond_earth:rocket_tier"));
                    return new PlanetSelectionMenu.GuiContainer(id, inventory, packetBuffer);
                }
            }, buf -> buf.writeInt(player.getPersistentData().m_128451_("beyond_earth:rocket_tier")));
        }
    }

    public static void entityFallWithLanderToPlanet(Entity entity, Level level) {
        Planets.Planet planet;
        if (entity.m_20202_().m_20186_() < (double)(level.m_141937_() + 1) && (planet = Planets.getLocationForOrbit(level)) != null) {
            Methods.teleportWithEntityTo(entity, entity.m_20202_(), planet.planet, 700);
        }
    }

    public static void entityFallToPlanet(Entity entity, Level level) {
        Planets.Planet planet;
        if (entity.m_20186_() < (double)(level.m_141937_() + 1) && (planet = Planets.getLocationForOrbit(level)) != null) {
            Methods.teleportTo(entity, planet.planet, 550.0);
        }
    }

    public static void disableFlyAntiCheat(Player player, boolean condition) {
        if (player instanceof ServerPlayer && condition) {
            ((ServerPlayer)player).f_8906_.f_9737_ = 0;
        }
    }

    public static void stopSound(ServerPlayer serverPlayer, ResourceLocation sound, SoundSource source) {
        ClientboundStopSoundPacket stopSoundS2CPacket = new ClientboundStopSoundPacket(sound, source);
        serverPlayer.f_8906_.m_9829_((Packet)stopSoundS2CPacket);
    }

    public static void sendVehicleHasNoFuelMessage(Player player) {
        if (!player.f_19853_.f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)"message.beyond_earth.no_fuel"), false);
        }
    }
}

