/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.ChunkOxygen;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.common.capabilities.oxygen.OxygenUtil;
import net.mrscauthd.beyond_earth.common.config.Config;
import net.mrscauthd.beyond_earth.common.registries.CapabilityRegistry;
import net.mrscauthd.beyond_earth.common.registries.TagRegistry;
import net.mrscauthd.beyond_earth.common.util.Methods;

public class OxygenSystem {
    private static final AirCheckResult ALWAYS_YES = new AirCheckResult(100);
    private static final AirCheckResult IN_FLUID = new AirCheckResult(-1);

    public static AirCheckResult canBreatheWithoutSuit(LivingEntity mob, boolean applyChunkO2) {
        boolean inWater;
        if (mob.m_6095_().m_204039_(TagRegistry.ENTITY_NO_OXYGEN_NEEDED_TAG)) {
            return ALWAYS_YES;
        }
        boolean bl = inWater = !mob.getEyeInFluidType().isAir();
        if (inWater) {
            return IN_FLUID;
        }
        Level level = mob.m_9236_();
        BlockPos pos = mob.m_20183_();
        ChunkOxygen chunkO2 = (ChunkOxygen)((LevelChunk)level.m_46865_(pos)).getCapability(CapabilityRegistry.CHUNK_OXYGEN).orElse(null);
        int O2 = chunkO2.getO2(pos);
        if (applyChunkO2) {
            chunkO2.addO2(pos, (byte)(-((Integer)Config.OXYGEN_BREATHE_AMOUNT.get()).intValue()), true);
        }
        return new AirCheckResult(O2);
    }

    public static boolean canBreatheFromSuit(LivingEntity mob, boolean consumeO2) {
        boolean hasO2;
        boolean isInSuit = Methods.isLivingInAnySpaceSuits(mob);
        if (!isInSuit) {
            return false;
        }
        ItemStack itemstack = mob.m_6844_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)2));
        IOxygenStorage oxygenStorage = OxygenUtil.getItemStackOxygenStorage(itemstack);
        boolean bl = hasO2 = oxygenStorage.getOxygen() > 0;
        if (consumeO2 && hasO2) {
            oxygenStorage.setOxygen(oxygenStorage.getOxygen() - 1);
        }
        return hasO2;
    }

    /*
     * Unable to fully structure code
     */
    public static void entityOxygen(LivingEntity entity, Level level) {
        if (level.m_5776_()) {
            return;
        }
        if (!(entity instanceof Player)) ** GOTO lbl-1000
        player = (Player)entity;
        if (player.m_150110_().f_35937_ || player.m_5833_()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        creativePlayer = v0;
        noSuitCheck = OxygenSystem.canBreatheWithoutSuit(entity, creativePlayer == false && entity.f_19797_ % (Integer)Config.OXYGEN_BREATHE_RATE.get() == 0);
        shouldFillAirSupply = ChunkOxygen.isBreatheable(noSuitCheck.O2());
        v1 = shouldFillAirSupply != false || OxygenSystem.canBreatheFromSuit(entity, creativePlayer == false && entity.f_19797_ % (Integer)Config.SUIT_BREATHE_RATE.get() == 0) != false ? true : (shouldFillAirSupply = false);
        if (shouldFillAirSupply) {
            entity.m_20301_(300);
        } else if (ChunkOxygen.isVacuum(noSuitCheck.O2())) {
            entity.m_20301_(-4);
            entity.getPersistentData().m_128347_("beyond_earth:oxygen_tick", entity.getPersistentData().m_128459_("beyond_earth:oxygen_tick") + 1.0);
            if (entity.getPersistentData().m_128459_("beyond_earth:oxygen_tick") > (double)((Integer)Config.VACUUM_DAMAGE_RATE.get()).intValue()) {
                Methods.hurtLivingWithOxygenSource(entity);
                entity.getPersistentData().m_128347_("beyond_earth:oxygen_tick", 0.0);
            }
        }
    }

    public record AirCheckResult(int O2) {
    }
}

