/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.datagen.provider;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.common.registries.BlockRegistry;

public class ModBlockStateProvider
extends BlockStateProvider {
    public String path;
    public String pathAfter;

    public ModBlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.setPath("", "");
        this.simpleBlock((Block)BlockRegistry.STEEL_BLOCK.get());
        this.simpleBlock((Block)BlockRegistry.DESH_BLOCK.get());
        this.simpleBlock((Block)BlockRegistry.OSTRUM_BLOCK.get());
        this.simpleBlock((Block)BlockRegistry.CALORITE_BLOCK.get());
        this.simpleBlock((Block)BlockRegistry.RAW_DESH_BLOCK.get());
        this.simpleBlock((Block)BlockRegistry.RAW_OSTRUM_BLOCK.get());
        this.simpleBlock((Block)BlockRegistry.RAW_CALORITE_BLOCK.get());
        this.simpleBlock((Block)BlockRegistry.METEORITE.get());
        this.setPath("decoration/", "");
        this.simpleBlock((Block)BlockRegistry.IRON_PLATING_BLOCK.get());
        this.axisBlock((RotatedPillarBlock)BlockRegistry.BLUE_IRON_PILLAR.get());
        this.axisBlock((RotatedPillarBlock)BlockRegistry.BARRICADE_BLOCK.get());
        this.axisBlock((RotatedPillarBlock)BlockRegistry.IRON_MARK_BLOCK.get());
        this.axisBlock((RotatedPillarBlock)BlockRegistry.DESH_PILLAR_BLOCK.get());
        this.simpleBlock((Block)BlockRegistry.DESH_PLATING_BLOCK.get());
        this.setPath("globes/", "");
        this.singleTextureWithoutParent((Block)BlockRegistry.EARTH_GLOBE_BLOCK.get());
        this.singleTextureWithoutParent((Block)BlockRegistry.MOON_GLOBE_BLOCK.get());
        this.singleTextureWithoutParent((Block)BlockRegistry.MARS_GLOBE_BLOCK.get());
        this.singleTextureWithoutParent((Block)BlockRegistry.MERCURY_GLOBE_BLOCK.get());
        this.singleTextureWithoutParent((Block)BlockRegistry.VENUS_GLOBE_BLOCK.get());
        this.singleTextureWithoutParent((Block)BlockRegistry.GLACIO_GLOBE_BLOCK.get());
        this.setPath("moon/", "");
        this.simpleBlock((Block)BlockRegistry.MOON_SAND.get());
        this.simpleBlock((Block)BlockRegistry.MOON_STONE.get());
        this.simpleBlock((Block)BlockRegistry.MOON_STONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.CRACKED_MOON_STONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.MOON_CHEESE_ORE.get());
        this.simpleBlock((Block)BlockRegistry.MOON_DESH_ORE.get());
        this.simpleBlock((Block)BlockRegistry.MOON_IRON_ORE.get());
        this.simpleBlock((Block)BlockRegistry.MOON_ICE_SHARD_ORE.get());
        this.slabBlock((SlabBlock)BlockRegistry.MOON_STONE_BRICK_SLAB.get(), this.key((Block)BlockRegistry.MOON_STONE_BRICKS.get()), this.blockTexture((Block)BlockRegistry.MOON_STONE_BRICKS.get()));
        this.stairsBlock((StairBlock)BlockRegistry.MOON_STONE_BRICK_STAIRS.get(), this.blockTexture((Block)BlockRegistry.MOON_STONE_BRICKS.get()));
        this.setPath("mars/", "");
        this.simpleBlock((Block)BlockRegistry.MARS_SAND.get());
        this.simpleBlock((Block)BlockRegistry.MARS_STONE.get());
        this.simpleBlock((Block)BlockRegistry.MARS_STONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.CRACKED_MARS_STONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.MARS_IRON_ORE.get());
        this.simpleBlock((Block)BlockRegistry.MARS_DIAMOND_ORE.get());
        this.simpleBlock((Block)BlockRegistry.MARS_OSTRUM_ORE.get());
        this.simpleBlock((Block)BlockRegistry.MARS_ICE_SHARD_ORE.get());
        this.slabBlock((SlabBlock)BlockRegistry.MARS_STONE_BRICK_SLAB.get(), this.key((Block)BlockRegistry.MARS_STONE_BRICKS.get()), this.blockTexture((Block)BlockRegistry.MARS_STONE_BRICKS.get()));
        this.stairsBlock((StairBlock)BlockRegistry.MARS_STONE_BRICK_STAIRS.get(), this.blockTexture((Block)BlockRegistry.MARS_STONE_BRICKS.get()));
        this.setPath("mercury/", "");
        this.simpleBlock((Block)BlockRegistry.MERCURY_STONE.get());
        this.simpleBlock((Block)BlockRegistry.MERCURY_STONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.CRACKED_MERCURY_STONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.MERCURY_IRON_ORE.get());
        this.slabBlock((SlabBlock)BlockRegistry.MERCURY_STONE_BRICK_SLAB.get(), this.key((Block)BlockRegistry.MERCURY_STONE_BRICKS.get()), this.blockTexture((Block)BlockRegistry.MERCURY_STONE_BRICKS.get()));
        this.stairsBlock((StairBlock)BlockRegistry.MERCURY_STONE_BRICK_STAIRS.get(), this.blockTexture((Block)BlockRegistry.MERCURY_STONE_BRICKS.get()));
        this.setPath("venus/", "");
        this.simpleBlock((Block)BlockRegistry.VENUS_SAND.get());
        this.cubeTop((Block)BlockRegistry.VENUS_STONE.get());
        this.simpleBlock((Block)BlockRegistry.VENUS_STONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.CRACKED_VENUS_STONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.VENUS_COAL_ORE.get());
        this.simpleBlock((Block)BlockRegistry.VENUS_GOLD_ORE.get());
        this.simpleBlock((Block)BlockRegistry.VENUS_DIAMOND_ORE.get());
        this.simpleBlock((Block)BlockRegistry.VENUS_CALORITE_ORE.get());
        this.slabBlock((SlabBlock)BlockRegistry.VENUS_STONE_BRICK_SLAB.get(), this.key((Block)BlockRegistry.VENUS_STONE_BRICKS.get()), this.blockTexture((Block)BlockRegistry.VENUS_STONE_BRICKS.get()));
        this.stairsBlock((StairBlock)BlockRegistry.VENUS_STONE_BRICK_STAIRS.get(), this.blockTexture((Block)BlockRegistry.VENUS_STONE_BRICKS.get()));
        this.simpleBlock((Block)BlockRegistry.VENUS_SANDSTONE.get());
        this.simpleBlock((Block)BlockRegistry.VENUS_SANDSTONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.CRACKED_VENUS_SANDSTONE_BRICKS.get());
        this.slabBlock((SlabBlock)BlockRegistry.VENUS_SANDSTONE_BRICK_SLAB.get(), this.key((Block)BlockRegistry.VENUS_SANDSTONE_BRICKS.get()), this.blockTexture((Block)BlockRegistry.VENUS_SANDSTONE_BRICKS.get()));
        this.stairsBlock((StairBlock)BlockRegistry.VENUS_SANDSTONE_BRICK_STAIRS.get(), this.blockTexture((Block)BlockRegistry.VENUS_SANDSTONE_BRICKS.get()));
        this.cubeTop((Block)BlockRegistry.INFERNAL_SPIRE.get());
        this.setPath("glacio/", "");
        this.simpleBlock((Block)BlockRegistry.GLACIO_STONE.get());
        this.simpleBlock((Block)BlockRegistry.GLACIO_STONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.CRACKED_GLACIO_STONE_BRICKS.get());
        this.simpleBlock((Block)BlockRegistry.GLACIO_ICE_SHARD_ORE.get());
        this.simpleBlock((Block)BlockRegistry.GLACIO_COAL_ORE.get());
        this.simpleBlock((Block)BlockRegistry.GLACIO_COPPER_ORE.get());
        this.simpleBlock((Block)BlockRegistry.GLACIO_IRON_ORE.get());
        this.simpleBlock((Block)BlockRegistry.GLACIO_LAPIS_ORE.get());
        this.slabBlock((SlabBlock)BlockRegistry.GLACIO_STONE_BRICK_SLAB.get(), this.key((Block)BlockRegistry.GLACIO_STONE_BRICKS.get()), this.blockTexture((Block)BlockRegistry.GLACIO_STONE_BRICKS.get()));
        this.stairsBlock((StairBlock)BlockRegistry.GLACIO_STONE_BRICK_STAIRS.get(), this.blockTexture((Block)BlockRegistry.GLACIO_STONE_BRICKS.get()));
        this.simpleBlock((Block)BlockRegistry.PERMAFROST.get());
        this.setPath("fluids/", "_still");
        this.simpleBlock((Block)BlockRegistry.FUEL_BLOCK.get());
        this.simpleBlock((Block)BlockRegistry.OIL_BLOCK.get());
    }

    public void cubeTop(Block block) {
        this.simpleBlock(block, new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().cubeTop(this.key(block).m_135815_(), new ResourceLocation(this.blockTexture(block) + "_side"), new ResourceLocation(this.blockTexture(block) + "_top")))});
    }

    public void singleTextureWithoutParent(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().getBuilder(this.key(block).m_135815_())).texture("particle", this.blockTexture(block)));
    }

    public BlockModelBuilder templateModel(Block block, String parentPath) {
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.key(block).m_135815_(), this.modLoc("template/" + parentPath))).texture("particle", this.blockTexture(block));
    }

    public void templateState(Block block, ModelFile modelFile) {
        this.simpleBlock(block, modelFile);
    }

    public void setPath(String path, String pathAfter) {
        this.path = path;
        this.pathAfter = pathAfter;
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public ResourceLocation blockTexture(Block block) {
        ResourceLocation name = this.key(block);
        return new ResourceLocation(name.m_135827_(), "block/" + this.path + name.m_135815_() + this.pathAfter);
    }
}

