/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.portable_energy_interface;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlock;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceMovement;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceTileEntity;
import com.mrh0.createaddition.index.CAPartials;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PortableEnergyInterfaceRenderer
extends SafeBlockEntityRenderer<PortableEnergyInterfaceTileEntity> {
    public PortableEnergyInterfaceRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(PortableEnergyInterfaceTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        BlockState blockState = te.m_58900_();
        float progress = te.getExtensionDistance(partialTicks);
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        PortableEnergyInterfaceRenderer.render(blockState, te.isConnected(), progress, null, sbb -> sbb.light(light).renderInto(ms, vb));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        BlockState blockState = context.state;
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();
        LerpedFloat animation = PortableEnergyInterfaceMovement.getAnimation(context);
        float progress = animation.getValue(renderPartialTicks);
        boolean lit = animation.settled();
        PortableEnergyInterfaceRenderer.render(blockState, lit, progress, matrices.getModel(), sbb -> sbb.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight((MovementContext)context, (VirtualRenderWorld)renderWorld)).renderInto(matrices.getViewProjection(), vb));
    }

    private static void render(BlockState blockState, boolean lit, float progress, PoseStack local, Consumer<SuperByteBuffer> drawCallback) {
        PartialModel middleForState = lit ? CAPartials.PORTABLE_ENERGY_INTERFACE_MIDDLE_POWERED : CAPartials.PORTABLE_ENERGY_INTERFACE_MIDDLE;
        SuperByteBuffer middle = CachedBufferer.partial((PartialModel)middleForState, (BlockState)blockState);
        SuperByteBuffer top = CachedBufferer.partial((PartialModel)CAPartials.PORTABLE_ENERGY_INTERFACE_TOP, (BlockState)blockState);
        if (local != null) {
            middle.transform(local);
            top.transform(local);
        }
        Direction facing = (Direction)blockState.m_61143_((Property)PortableEnergyInterfaceBlock.f_52588_);
        PortableEnergyInterfaceRenderer.rotateToFacing(middle, facing);
        PortableEnergyInterfaceRenderer.rotateToFacing(top, facing);
        middle.translate(0.0, (double)(progress * 0.5f + 0.375f), 0.0);
        top.translate(0.0, (double)progress, 0.0);
        drawCallback.accept(middle);
        drawCallback.accept(top);
    }

    private static void rotateToFacing(SuperByteBuffer buffer, Direction facing) {
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buffer.centre()).rotateY((double)AngleHelper.horizontalAngle((Direction)facing))).rotateX(facing == Direction.UP ? 0.0 : (facing == Direction.DOWN ? 180.0 : 90.0))).unCentre();
    }

    static PortableEnergyInterfaceTileEntity getTargetPSI(MovementContext context) {
        String _workingPos_ = "WorkingPos";
        if (!context.data.m_128441_(_workingPos_)) {
            return null;
        }
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)context.data.m_128469_(_workingPos_));
        BlockEntity tileEntity = context.world.m_7702_(pos);
        if (tileEntity instanceof PortableEnergyInterfaceTileEntity) {
            PortableEnergyInterfaceTileEntity psi = (PortableEnergyInterfaceTileEntity)tileEntity;
            return !psi.isTransferring() ? null : psi;
        }
        return null;
    }
}

